/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/13
 */
package test.org.asyrinx.brownie.core.lang;

import java.lang.reflect.InvocationTargetException;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.lang.PropertyUtils;
import org.asyrinx.brownie.core.lang.UnsupportedClassRuntimeException;

/**
 * @author akima
 */
public class PropertyUtilsTest extends TestCase {

    /**
     * Constructor for PropertyUtilsTest.
     * 
     * @param name
     */
    public PropertyUtilsTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(PropertyUtilsTest.class);
    }

    public static class TestObjectA {
        private int intValue = 0;

        private boolean booleanValue = false;

        private String stringValue = "";

        public boolean isBooleanValue() {
            return booleanValue;
        }

        public int getIntValue() {
            return intValue;
        }

        public String getStringValue() {
            return stringValue;
        }

        public void setBooleanValue(boolean b) {
            booleanValue = b;
        }

        public void setIntValue(int i) {
            intValue = i;
        }

        public void setStringValue(String string) {
            stringValue = string;
        }

    }

    public static class TestObjectB {
        private TestObjectA objectA = null;

        public TestObjectA getObjectA() {
            return objectA;
        }

        public void setObjectA(TestObjectA objectA) {
            this.objectA = objectA;
        }
    }

    public void testGetPropertyAsString() {
        final TestObjectA a = new TestObjectA();
        a.setBooleanValue(true);
        a.setStringValue("hjkgfd");
        a.setIntValue(1897);
        final TestObjectB b = new TestObjectB();
        final TestObjectB b2 = new TestObjectB();
        b.setObjectA(a);
        assertEquals("true", PropertyUtils.getPropertyAsString(a, "booleanValue"));
        assertEquals("1897", PropertyUtils.getPropertyAsString(a, "intValue"));
        assertEquals("hjkgfd", PropertyUtils.getPropertyAsString(a, "stringValue"));

        assertEquals("true", PropertyUtils.getPropertyAsString(b, "objectA.booleanValue"));
        assertEquals("1897", PropertyUtils.getPropertyAsString(b, "objectA.intValue"));
        assertEquals("hjkgfd", PropertyUtils.getPropertyAsString(b, "objectA.stringValue"));

        assertEquals(null, PropertyUtils.getPropertyAsString(b2, "objectA.booleanValue"));
        assertEquals(null, PropertyUtils.getPropertyAsString(b2, "objectA.intValue"));
        assertEquals(null, PropertyUtils.getPropertyAsString(b2, "objectA.stringValue"));
    }

    public void testGetPropertyAsInt() {
        final TestObjectA a = new TestObjectA();
        a.setBooleanValue(true);
        a.setStringValue("hjkgfd");
        a.setIntValue(1897);
        final TestObjectB b = new TestObjectB();
        final TestObjectB b2 = new TestObjectB();
        b.setObjectA(a);
        assertEquals(0, PropertyUtils.getPropertyAsInt(a, "booleanValue"));
        assertEquals(1897, PropertyUtils.getPropertyAsInt(a, "intValue"));
        assertEquals(0, PropertyUtils.getPropertyAsInt(a, "stringValue"));

        assertEquals(0, PropertyUtils.getPropertyAsInt(b, "objectA.booleanValue"));
        assertEquals(1897, PropertyUtils.getPropertyAsInt(b, "objectA.intValue"));
        assertEquals(0, PropertyUtils.getPropertyAsInt(b, "objectA.stringValue"));

        assertEquals(0, PropertyUtils.getPropertyAsInt(b2, "objectA.booleanValue"));
        assertEquals(0, PropertyUtils.getPropertyAsInt(b2, "objectA.intValue"));
        assertEquals(0, PropertyUtils.getPropertyAsInt(b2, "objectA.stringValue"));
    }

    public void testGetPropertyAsBoolean() {
        final TestObjectA a = new TestObjectA();
        a.setBooleanValue(true);
        a.setStringValue("hjkgfd");
        a.setIntValue(1897);
        final TestObjectB b = new TestObjectB();
        final TestObjectB b2 = new TestObjectB();
        b.setObjectA(a);

        assertEquals(true, PropertyUtils.getPropertyAsBoolean(a, "booleanValue"));
        assertEquals(false, PropertyUtils.getPropertyAsBoolean(a, "intValue"));
        assertEquals(false, PropertyUtils.getPropertyAsBoolean(a, "stringValue"));

        assertEquals(true, PropertyUtils.getPropertyAsBoolean(b, "objectA.booleanValue"));
        assertEquals(false, PropertyUtils.getPropertyAsBoolean(b, "objectA.intValue"));
        assertEquals(false, PropertyUtils.getPropertyAsBoolean(b, "objectA.stringValue"));

        assertEquals(false, PropertyUtils.getPropertyAsBoolean(b2, "objectA.booleanValue"));
        assertEquals(false, PropertyUtils.getPropertyAsBoolean(b2, "objectA.intValue"));
        assertEquals(false, PropertyUtils.getPropertyAsBoolean(b2, "objectA.stringValue"));
    }

    public void testGetPropertyObjectStringClass() {
        final TestObjectB objectB = new TestObjectB();
        try {
            assertEquals(null, PropertyUtils.getProperty(objectB, "objectA", TestObjectA.class));
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }
        final TestObjectA objectA = new TestObjectA();
        objectB.setObjectA(objectA);
        try {
            assertEquals(objectA, PropertyUtils.getProperty(objectB, "objectA", TestObjectA.class));
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }
    }

    public void testRequirePropertyObjectStringClass() {
        final TestObjectB objectB = new TestObjectB();
        try {
            PropertyUtils.requireProperty(objectB, "objectA", TestObjectA.class);
            fail();
        } catch (UnsupportedClassRuntimeException e) {
            assertTrue(true);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }
        final TestObjectA objectA = new TestObjectA();
        objectB.setObjectA(objectA);
        try {
            assertEquals(objectA, PropertyUtils.requireProperty(objectB, "objectA", TestObjectA.class));
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }
    }

}