/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/13
 */
package test.org.asyrinx.brownie.core.lang.enum;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.lang.enum.ValuedEnum;

/**
 * @author akima
 */
public class ValuedEnumTest extends TestCase {

	/**
	 * Constructor for ValuedEnumTest.
	 * @param name
	 */
	public ValuedEnumTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(ValuedEnumTest.class);
	}

	public static class TestValuedEnum extends ValuedEnum {
		public TestValuedEnum(String name, int value) {
			super(name, new Integer(value));
		}
		public int toInt() {
			return ((Integer) getValue()).intValue();
		}

		public static TestValuedEnum get(int value) {
			return (TestValuedEnum) ValuedEnum.getEnum(
				TestValuedEnum.class,
				new Integer(value));
		}
	}

	public static final TestValuedEnum ABC = new TestValuedEnum("abc", 1);
	public static final TestValuedEnum XYZ = new TestValuedEnum("xyz", 9);

	public void testGet() {
		assertEquals(1, ABC.toInt());
		assertEquals(9, XYZ.toInt());
		assertEquals(null, TestValuedEnum.get(0));
		assertEquals(ABC, TestValuedEnum.get(1));
		assertEquals(XYZ, TestValuedEnum.get(9));
	}

	public void testGetByName() {
		assertEquals(
			ABC,
			TestValuedEnum.getEnumByName(TestValuedEnum.class, "abc"));
		assertEquals(
			null,
			TestValuedEnum.getEnumByName(TestValuedEnum.class, "def"));
		assertEquals(
			XYZ,
			TestValuedEnum.getEnumByName(TestValuedEnum.class, "xyz"));

	}
}
