/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/07 15:32:21
 */
package test.org.asyrinx.brownie.core.resource.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.resource.MessageResource;
import org.asyrinx.brownie.core.resource.MessageResourceRuntimeException;
import org.asyrinx.brownie.core.resource.impl.CompositeMessageResource;
import org.asyrinx.brownie.core.resource.impl.PropertiesMessageResource;

/**
 * @author takeshi
 */
public class CompositeMessageResourceTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(CompositeMessageResourceTest.class);
    }

    private static final String KEY1 = "org.asyrinx.brownie.core.resource.impl.test.value1";

    private static final String KEY2 = "org.asyrinx.brownie.core.resource.impl.test.value2";

    private static final String KEY3 = "org.asyrinx.brownie.core.resource.impl.test.value3";

    private static final String KEY4 = "org.asyrinx.brownie.core.resource.impl.test.value4";

    public void testGetMessage() {
        final Properties properties = new Properties();
        properties.setProperty(KEY1, "ςςς");
        properties.setProperty(KEY3, "łłł");
        properties.setProperty(KEY4, "催催");
        final File textFile;
        try {
            textFile = File.createTempFile("brownie-test", ".properties");
            properties.store(new FileOutputStream(textFile), "");
        } catch (IOException e) {
            e.printStackTrace();
            fail();
            return;
        }
        //
        final MessageResource messageResource1 = ResourceBundleMessageResourceTest.createTestResource(null);
        final MessageResource messageResource2 = new PropertiesMessageResource(textFile.getPath());
        //
        final CompositeMessageResource composite1 = new CompositeMessageResource();
        composite1.add(messageResource1);
        composite1.add(messageResource2);
        assertEquals("", composite1.getMessage(KEY1));
        assertEquals("", composite1.getMessage(KEY2));
        assertEquals("łłł", composite1.getMessage(KEY3));
        assertEquals("催催", composite1.getMessage(KEY4));
        //
        final CompositeMessageResource composite2 = new CompositeMessageResource();
        composite2.add(messageResource2); //tɂƎlς
        composite2.add(messageResource1);
        assertEquals("ςςς", composite2.getMessage(KEY1));
        assertEquals("", composite2.getMessage(KEY2));
        assertEquals("łłł", composite2.getMessage(KEY3));
        assertEquals("催催", composite2.getMessage(KEY4));
        //
        try {
            composite2.getMessage("unused key");
            fail();
        } catch (MessageResourceRuntimeException e) {
            //OK!
        }
    }

}