/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/07 14:55:13
 */
package test.org.asyrinx.brownie.core.resource.impl;

import java.util.Locale;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.asyrinx.brownie.core.resource.impl.ResourceBundleMessageResource;

import junit.framework.TestCase;

/**
 * @author takeshi
 */
public class ResourceBundleMessageResourceTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ResourceBundleMessageResourceTest.class);
    }

    /**
     * @param locale
     * @return
     */
    public static ResourceBundleMessageResource createTestResource(Locale locale) {
        final String path = "test.org.asyrinx.brownie.core.resource.impl.test";
        if (locale == null) {
            return new ResourceBundleMessageResource(path);
        } else {
            return new ResourceBundleMessageResource(path, locale);
        }
    }

    private static final String KEY1 = "org.asyrinx.brownie.core.resource.impl.test.value1";

    private static final String KEY2 = "org.asyrinx.brownie.core.resource.impl.test.value2";

    private Log log = LogFactory.getLog(this.getClass());

    public void testLocaleEnglish() {
        log.debug("testLocaleEnglish 0");
        final Locale bak = Locale.getDefault();
        try {
            log.debug("testLocaleEnglish 1");
            Locale.setDefault(Locale.US);
            log.debug("testLocaleEnglish 2");
            final ResourceBundleMessageResource resource0 = createTestResource(null);
            log.debug("testLocaleEnglish 3");
            assertEquals("aaaa", resource0.getMessage(KEY1));
            assertEquals("bbbb", resource0.getMessage(KEY2));
            //
            final ResourceBundleMessageResource resource1 = createTestResource(Locale.JAPAN);
            assertEquals("", resource1.getMessage(KEY1));
            assertEquals("", resource1.getMessage(KEY2));
            //
            final ResourceBundleMessageResource resource2 = createTestResource(Locale.JAPANESE);
            assertEquals("", resource2.getMessage(KEY1));
            assertEquals("", resource2.getMessage(KEY2));
            //
            final ResourceBundleMessageResource resource3 = createTestResource(Locale.ENGLISH);
            assertEquals("aaaa", resource3.getMessage(KEY1));
            assertEquals("bbbb", resource3.getMessage(KEY2));
        } catch (Throwable e) {
            e.printStackTrace();
        } finally {
            Locale.setDefault(bak);
        }
    }

    public void testLocaleJapanese() {
        final Locale bak = Locale.getDefault();
        try {
            Locale.setDefault(Locale.JAPAN);
            final ResourceBundleMessageResource resource0 = createTestResource(null);
            assertEquals("", resource0.getMessage(KEY1));
            assertEquals("", resource0.getMessage(KEY2));
            //
            final ResourceBundleMessageResource resource1 = createTestResource(Locale.JAPAN);
            assertEquals("", resource1.getMessage(KEY1));
            assertEquals("", resource1.getMessage(KEY2));
            //
            final ResourceBundleMessageResource resource2 = createTestResource(Locale.JAPANESE);
            assertEquals("", resource2.getMessage(KEY1));
            assertEquals("", resource2.getMessage(KEY2));
            //
            //ENGLISHw肵Ătest_en.properties͂Ȃ̂ŃftHgP[jagB
            final ResourceBundleMessageResource resource3 = createTestResource(Locale.ENGLISH);
            assertEquals("", resource3.getMessage(KEY1));
            assertEquals("", resource3.getMessage(KEY2));
        } finally {
            Locale.setDefault(bak);
        }
    }

}