/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/07 7:38:18
 */
package test.org.asyrinx.brownie.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.util.ArrayComparator;

/**
 * @author akima
 */
public class ArrayComparatorTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ArrayComparatorTest.class);
    }

    public void testCompare() {
        final Comparator comparator = new ArrayComparator();
        final List list = new ArrayList() {
            //println̂߂override
            public String toString() {
                final StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("{");
                for (Iterator iter = iterator(); iter.hasNext();) {
                    stringBuffer.append(" [");
                    final Object[] array = (Object[]) iter.next();
                    for (int i = 0; i < array.length; i++) {
                        if (i != 0)
                            stringBuffer.append(", ");
                        stringBuffer.append(array[i]);
                    }
                    stringBuffer.append(" ], ");
                }
                stringBuffer.append("}");
                return stringBuffer.toString();
            }
        };
        final Object[][] arrays = new Object[][] {//
        new Object[] { "c", "a", "a", }, //0
                new Object[] { "b", "a", "a", }, //1
                new Object[] { "b", "a", }, //2
                new Object[] { "a", "a", "a", }, //3
                new Object[] { "c", "a", "b", }, //4
                new Object[] { "a", "a", }, //5
                new Object[] { "c", "a", "a", null }, //6
                new Object[] { "b", "b", "a", }, //7
        };
        for (int i = 0; i < arrays.length; i++)
            list.add(arrays[i]);
        Collections.sort(list, comparator);
        //
        //System.out.println(list);
        assertEquals(arrays[5], list.get(0));
        assertEquals(arrays[3], list.get(1));
        assertEquals(arrays[2], list.get(2));
        assertEquals(arrays[1], list.get(3));
        assertEquals(arrays[7], list.get(4));
        assertEquals(arrays[0], list.get(5));
        assertEquals(arrays[6], list.get(6));
        assertEquals(arrays[4], list.get(7));
    }

}