/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/19 2:59:22
 */
package test.org.asyrinx.brownie.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.collection.matrix.ArrayListMatrix;
import org.asyrinx.brownie.core.collection.matrix.ListMatrix;
import org.asyrinx.brownie.jdbc.ResultSetFilter;
import org.asyrinx.brownie.jdbc.mockbase.MockBaseResultSet;
import org.asyrinx.brownie.jdbc.mockbase.MockBaseStatement;

/**
 * @author akima
 */
public class ResultSetFilterTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ResultSetFilterTest.class);
    }

    private Statement statement = null;

    protected void setUp() throws Exception {
        final ListMatrix matrix = new ArrayListMatrix();
        matrix.put(0, 0, "a1");
        matrix.put(1, 0, "b1");
        matrix.put(2, 0, "c1");
        matrix.put(0, 1, "a2");
        matrix.put(1, 1, "");
        matrix.put(2, 1, null);
        matrix.put(0, 2, null);
        matrix.put(1, 2, "b3");
        matrix.put(2, 2, "c3");
        //
        final ResultSet mockResultSet = new MockBaseResultSet() {
            private int index = -1;

            public String getString(int columnIndex) throws SQLException {
                final Object val = matrix.get(columnIndex, index);
                return (val == null) ? null : val.toString();
            }

            public boolean next() throws SQLException {
                index++;
                return index < matrix.rowSize();
            }

            public boolean previous() throws SQLException {
                index--;
                return index > 0;
            }
        };
        //
        this.statement = new MockBaseStatement() {
            public ResultSet executeQuery(String sql) throws SQLException {
                return mockResultSet;
            }
        };
    }

    /*
     * Class under test for ResultSet toDefaultString(ResultSet, String)
     */
    public void testToDefaultStringResultSetString() {
        final List beans = new ArrayList();
        try {
            final ResultSet resultSet = ResultSetFilter.toDefaultString(statement
                    .executeQuery("select a, b, c from test1"), "");
            try {
                while (resultSet.next()) {
                    final Test1 bean = new Test1();
                    bean.setA(resultSet.getString(0));
                    bean.setB(resultSet.getString(1));
                    bean.setC(resultSet.getString(2));
                    beans.add(bean);
                }
            } finally {
                resultSet.close();
            }
        } catch (SQLException e) {
            e.printStackTrace();
            fail();
        }
        assertEquals(3, beans.size());
        final Test1 test1_1 = (Test1) beans.get(0);
        assertEquals("a1", test1_1.getA());
        assertEquals("b1", test1_1.getB());
        assertEquals("c1", test1_1.getC());
        final Test1 test1_2 = (Test1) beans.get(1);
        assertEquals("a2", test1_2.getA());
        assertEquals("", test1_2.getB());
        assertEquals("", test1_2.getC());
        final Test1 test1_3 = (Test1) beans.get(2);
        assertEquals("", test1_3.getA());
        assertEquals("b3", test1_3.getB());
        assertEquals("c3", test1_3.getC());
    }

    public void testTrim() {
    }

    public void testMaxCount() {
    }

    public static final class Test1 {
        private String a = null;

        private String b = null;

        private String c = null;

        /**
         * @return Returns the a.
         */
        public String getA() {
            return a;
        }

        /**
         * @param a
         *               The a to set.
         */
        public void setA(String a) {
            this.a = a;
        }

        /**
         * @return Returns the b.
         */
        public String getB() {
            return b;
        }

        /**
         * @param b
         *               The b to set.
         */
        public void setB(String b) {
            this.b = b;
        }

        /**
         * @return Returns the c.
         */
        public String getC() {
            return c;
        }

        /**
         * @param c
         *               The c to set.
         */
        public void setC(String c) {
            this.c = c;
        }
    }
}