/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/07 11:32:25
 */
package test.org.asyrinx.brownie.validator;

import java.util.Iterator;
import java.util.List;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

import org.asyrinx.brownie.core.resource.MessageResource;
import org.asyrinx.brownie.core.resource.impl.ResourceBundleMessageResource;
import org.asyrinx.brownie.validator.Message;
import org.asyrinx.brownie.validator.ValidationContext;
import org.asyrinx.brownie.validator.Validator;
import org.asyrinx.brownie.validator.impl.ValidationContextImpl;

/**
 * @author takeshi
 */
public class TestUtils {
    /**
     * @param v
     * @param arg
     */
    public static ValidationContext assertNG(Validator v, Object arg) {
        return check(v, arg, false);
    }

    /**
     * @param v
     * @param arg
     * @return
     */
    private static ValidationContextImpl invokeValidation(Validator v, Object arg) {
        final ValidationContextImpl context = new ValidationContextImpl();
        context.setResource(resource);
        v.evaluate(context, arg);
        return context;
    }

    /**
     * @param v
     * @param arg
     */
    public static ValidationContext assertNG(Validator v, Object arg, int msgSize) {
        final ValidationContextImpl context = invokeValidation(v, arg);
        try {
            TestCase.assertEquals(msgSize, context.getMessages().size());
        } catch (AssertionFailedError e) {
            showContext(context);
            throw e;
        }
        return context;
    }

    /**
     * @param context
     * @return
     */
    private static void showContext(final ValidationContextImpl context) {
        final List messages = context.getMessages();
        System.out.println("context[" + context + "] has " + messages.size() + " message(s).");
        int idx = 0;
        for (Iterator i = messages.iterator(); i.hasNext();) {
            final Message message = (Message) i.next();
            System.out.println("message[" + idx++ + "]:" + message.getText());
        }
    }

    /**
     * @param v
     * @param arg
     */
    public static ValidationContext assertOK(Validator v, Object arg) {
        return check(v, arg, true);
    }

    private static final MessageResource resource = new ResourceBundleMessageResource(
            "org.asyrinx.brownie.validator.prop.property-validation");

    /**
     * @param v
     * @param arg
     * @param emptyValue
     * @return
     */
    private static ValidationContext check(Validator v, Object arg, boolean emptyValue) {
        final ValidationContextImpl context = invokeValidation(v, arg);
        final List messages = context.getMessages();
        try {
            TestCase.assertEquals(emptyValue, messages.isEmpty());
        } catch (AssertionFailedError e) {
            if (!messages.isEmpty())
                throw new AssertionFailedError(((Message) messages.get(0)).getText());
            else
                throw e;
        }
        return context;
    }

}