/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/07 12:56:52
 */
package test.org.asyrinx.brownie.validator.impl;

import org.asyrinx.brownie.validator.MessageLevel;
import org.asyrinx.brownie.validator.ValidationContext;
import org.asyrinx.brownie.validator.Validator;
import org.asyrinx.brownie.validator.impl.CompositeType;
import org.asyrinx.brownie.validator.impl.CompositeValidator;

import test.org.asyrinx.brownie.validator.TestUtils;

import junit.framework.TestCase;

/**
 * @author takeshi
 */
public class CompositeValidatorTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(CompositeValidatorTest.class);
    }

    public static class MockValidator implements Validator {
        public MockValidator(boolean success) {
            this(success, null);
        }

        public MockValidator(boolean success, String message) {
            this.success = success;
            this.message = message;
        }

        protected final String message;

        protected final boolean success;

        public void evaluate(ValidationContext context, Object obj) {
            if (success)
                return;
            context.addMessage(message, MessageLevel.ERROR);
        }
    }

    public void testSimple() {
        final CompositeValidator composite1 = new CompositeValidator();
        composite1.add(new MockValidator(true));
        composite1.add(new MockValidator(true));
        TestUtils.assertOK(composite1, null);
        //
        final CompositeValidator composite2 = new CompositeValidator();
        composite2.add(new MockValidator(true));
        composite2.add(new MockValidator(true));
        composite2.add(new MockValidator(false));
        TestUtils.assertNG(composite2, null, 1);
        //
        composite2.setType(CompositeType.OR);
        TestUtils.assertOK(composite2, null);
        //
        final CompositeValidator composite3 = new CompositeValidator();
        composite3.setType(CompositeType.OR);
        composite3.add(new MockValidator(false));
        composite3.add(new MockValidator(false));
        composite3.add(new MockValidator(false));
        TestUtils.assertNG(composite3, null, 3);
    }

    public void testTree() {
        final CompositeValidator composite1 = new CompositeValidator();
        composite1.setType(CompositeType.AND);
        composite1.add(new MockValidator(false));
        composite1.add(new MockValidator(true));
        final CompositeValidator composite2 = new CompositeValidator();
        composite1.add(composite2);
        composite2.setType(CompositeType.AND);
        composite2.add(new MockValidator(false));
        composite2.add(new MockValidator(true));
        final CompositeValidator composite3 = new CompositeValidator();
        composite1.add(composite3);
        composite3.setType(CompositeType.AND);
        composite3.add(new MockValidator(false));
        composite3.add(new MockValidator(true));
        final CompositeValidator composite4 = new CompositeValidator();
        composite3.add(composite4);
        composite4.setType(CompositeType.AND);
        composite4.add(new MockValidator(false));
        composite4.add(new MockValidator(true));
        //
        // composite1[AND]
        // +---- composite2[AND]
        // +---- composite3[AND]
        //          +---- composite4[AND]
        TestUtils.assertNG(composite1, null, 4);
        //
        // composite1[AND]
        // +---- composite2[AND]
        // +---- composite3[AND]
        //          +---- composite4[OR]
        composite4.setType(CompositeType.OR);
        TestUtils.assertNG(composite1, null, 3);
        //
        // composite1[AND]
        // +---- composite2[AND]
        // +---- composite3[OR]
        //          +---- composite4[OR]
        composite3.setType(CompositeType.OR);
        TestUtils.assertNG(composite1, null, 2);
        //
        // composite1[AND]
        // +---- composite2[OR]
        // +---- composite3[OR]
        //          +---- composite4[OR]
        composite2.setType(CompositeType.OR);
        TestUtils.assertNG(composite1, null, 1);
        //
        // composite1[OR]
        // +---- composite2[OR]
        // +---- composite3[OR]
        //          +---- composite4[OR]
        composite1.setType(CompositeType.OR);
        TestUtils.assertOK(composite1, null);
        //
        // composite1[OR]
        // +---- composite2[OR]
        // +---- composite3[OR]
        //          +---- composite4[AND]
        composite4.setType(CompositeType.AND);
        TestUtils.assertOK(composite1, null);
        //
        // composite1[OR]
        // +---- composite2[OR]
        // +---- composite3[AND]
        //          +---- composite4[AND]
        composite3.setType(CompositeType.AND);
        TestUtils.assertOK(composite1, null);
        //
        // composite1[AND]
        // +---- composite2[OR]
        // +---- composite3[AND]
        //          +---- composite4[AND]
        composite1.setType(CompositeType.AND);
        TestUtils.assertNG(composite1, null, 3);

    }
}