/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/08 21:52:58
 */
package test.org.asyrinx.brownie.validator.prop;

import org.asyrinx.brownie.validator.Message;
import org.asyrinx.brownie.validator.ValidationContext;
import org.asyrinx.brownie.validator.Validator;
import org.asyrinx.brownie.validator.prop.AcceptableCharacter;

import test.org.asyrinx.brownie.validator.JapaneseTestCase;
import test.org.asyrinx.brownie.validator.TestObject;
import test.org.asyrinx.brownie.validator.TestUtils;

/**
 * @author takeshi
 */
public class AcceptableCharacterTest extends JapaneseTestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(AcceptableCharacterTest.class);
    }

    public void testEvaluate() {
        final Validator v = new AcceptableCharacter("stringProperty", "񑮐", "0123456789-");
        //
        final TestObject object1 = new TestObject();
        //
        object1.setStringProperty(null);
        TestUtils.assertOK(v, object1);
        //
        object1.setStringProperty("0123-111");
        TestUtils.assertOK(v, object1);
        //
        ValidationContext context;
        Message message;
        //
        object1.setStringProperty("0123AA");
        context = TestUtils.assertNG(v, object1, 1);
        message = (Message) context.getMessages().get(0);
        assertEquals("񑮐 Ɏgpł镶 0123456789- łB", message.getText());
        //
        object1.setStringProperty("abc");
        TestUtils.assertNG(v, object1);
    }

}