/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.ant.task;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.texen.Generator;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.joey.gen.ant.ModelLoader;
import org.asyrinx.joey.gen.ant.task.MultiTargetTexenTask;
import org.asyrinx.joey.gen.ant.task.SchemaBackup;
import org.asyrinx.joey.gen.core.JoeyGenerateTarget;
import org.asyrinx.joey.gen.core.VelocityHelper;
import org.asyrinx.joey.gen.core.VelocityOgnlAccessor;
import org.asyrinx.joey.gen.core.VelocityOgnlHelper;
import org.asyrinx.joey.gen.core.impl.S2ContainerLoader;
import org.asyrinx.joey.gen.hibernate.HibernateUtils;
import org.asyrinx.joey.gen.model.java.AppDomain;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.seasar.framework.container.S2Container;
import org.xml.sax.SAXException;

public class JoeyGenerateTask
extends MultiTargetTexenTask {
    private S2Container container = S2ContainerLoader.getContainer();
    private Generator generator = null;
    private SchemaBackup schemaBackup = new SchemaBackup();
    private static final String DEFAULT_PROPERTIES_PATH = "org/asyrinx/joey/gen/ant/task/default.properties";
    protected List filesets = new ArrayList();
    private String targetTextFile = null;
    private String projDir = null;
    private String javaSrcDir = null;
    private String testSrcDir = null;
    private String webappDir = null;
    private File lastSchemaDir = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public Context initControlContext() {
        if (this.filesets.isEmpty()) {
            throw new BuildException("There's no schema file. You must specify fileset of schema files!");
        }
        VelocityContext result = new VelocityContext();
        try {
            this.loadModels((Context)result);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        return result;
    }

    protected Generator initGenerator() {
        if (this.generator == null) {
            Object gen;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.asyrinx.joey.gen.core.JoeyVelocityGenerator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((gen = this.container.getComponent((Object)clazz)) instanceof Generator) {
                this.generator = (Generator)gen;
            } else {
                StringBuffer stringBuffer = new StringBuffer("JoeyVelocityGenerator object must extends ");
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.apache.velocity.texen.Generator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new BuildException(stringBuffer.append(clazz2.getName()).toString());
            }
        }
        return this.generator;
    }

    private void loadModels(Context context) throws IOException, SAXException {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.asyrinx.joey.gen.ant.ModelLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ModelLoader modelLoader = (ModelLoader)this.container.getComponent((Object)clazz);
        Databases databases = modelLoader.loadDatabaseModels(this.filesets, this.project);
        AppDomain domain = modelLoader.loadAppDomainModel(databases, this.project);
        Map rdb2Java = modelLoader.getRdb2Java();
        this.schemaBackup.execute(this.project, this.filesets, this.lastSchemaDir);
        context.put("databases", (Object)databases);
        context.put("domain", (Object)domain);
        context.put("rdb2java", (Object)rdb2Java);
        context.put("helper", (Object)new VelocityHelper(context));
        context.put("ognl", (Object)new VelocityOgnlHelper(context));
        context.put("stringUtils", (Object)new StringUtils());
        context.put("hibernateUtils", (Object)new HibernateUtils());
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("java.util.Map");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        OgnlRuntime.setPropertyAccessor(clazz2, (PropertyAccessor)new VelocityOgnlAccessor(context));
    }

    private List loadTargetFile() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.getTargetTextFile()));
            String line = reader.readLine();
            while (line != null) {
                if (!(StringUtils.isEmpty((String)(line = line.trim())) || line.startsWith("#") || result.contains(line))) {
                    this.log.debug((Object)(String.valueOf(this.getTargetTextFile()) + " target: " + line));
                    result.add(line);
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        return result;
    }

    protected List initTargets() {
        Properties properties = this.getDefaultProperties();
        List source = this.loadTargetFile();
        ArrayList<JoeyGenerateTarget> result = new ArrayList<JoeyGenerateTarget>();
        Iterator i = source.iterator();
        while (i.hasNext()) {
            String line = (String)i.next();
            JoeyGenerateTarget target = this.createTarget(properties, line);
            result.add(target);
        }
        return result;
    }

    private JoeyGenerateTarget createTarget(Properties properties, String line) {
        String controlKey = "joey-gen.template.control." + line;
        String destKey = "joey-gen.template.dest." + line;
        String controlTemplate = String.valueOf(properties.getProperty(controlKey));
        String targetStr = String.valueOf(properties.getProperty(destKey));
        try {
            String destDir = this.getDestDir(targetStr);
            return new JoeyGenerateTarget(line, destDir, controlTemplate);
        }
        catch (BuildException e) {
            throw new BuildException("no destDir in property for '" + destKey + "'", (Throwable)e);
        }
    }

    private Properties getDefaultProperties() {
        Properties properties = new Properties();
        InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(DEFAULT_PROPERTIES_PATH);
        try {
            properties.load(stream);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        return properties;
    }

    private String getDestDir(String targetStr) {
        if (targetStr == null) {
            return this.getJavaSrcDir();
        }
        if ("javasrc".equals(targetStr)) {
            return this.getJavaSrcDir();
        }
        if ("testsrc".equals(targetStr)) {
            return this.getTestSrcDir();
        }
        if ("proj".equals(targetStr)) {
            return this.getProjDir();
        }
        if ("webapp".equals(targetStr)) {
            return this.getWebappDir();
        }
        throw new BuildException("Illegal targetStr '" + targetStr + "'");
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void setContextProperties(String file) {
        String newKey;
        String key;
        super.setContextProperties(file);
        Hashtable env = super.getProject().getProperties();
        Iterator i = env.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            if (!key.startsWith("joey-gen.")) continue;
            newKey = this.toVelocityKey(key.substring("joey-gen.".length()));
            this.contextProperties.setProperty(newKey, env.get(key));
            this.log.debug((Object)("joey-gen property available: " + newKey + ":" + env.get(key)));
        }
        i = env.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            if (!key.startsWith("proj.")) continue;
            newKey = this.toVelocityKey(key);
            this.contextProperties.setProperty(newKey, env.get(key));
            this.log.debug((Object)("project property available: " + newKey + ":" + env.get(key)));
        }
    }

    private String toVelocityKey(String newKey) {
        int j = newKey.indexOf(".");
        while (j != -1) {
            newKey = String.valueOf(newKey.substring(0, j)) + StringUtils.capitalize((String)newKey.substring(j + 1));
            j = newKey.indexOf(".");
        }
        return newKey;
    }

    public String getTargetTextFile() {
        return this.targetTextFile;
    }

    public void setTargetTextFile(File targetTextFile) {
        try {
            this.targetTextFile = targetTextFile.getCanonicalPath();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public String getJavaSrcDir() {
        return this.javaSrcDir;
    }

    public String getProjDir() {
        return this.projDir;
    }

    public String getTestSrcDir() {
        return this.testSrcDir;
    }

    public String getWebappDir() {
        return this.webappDir;
    }

    public void setJavaSrcDir(File javaSrcDir) {
        try {
            this.javaSrcDir = javaSrcDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setProjDir(File projDir) {
        try {
            this.projDir = projDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setTestSrcDir(File testSrcDir) {
        try {
            this.testSrcDir = testSrcDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setWebappDir(File webappDir) {
        try {
            this.webappDir = webappDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public File getLastSchemaDir() {
        return this.lastSchemaDir;
    }

    public void setLastSchemaDir(File lastSchemaDir) {
        this.lastSchemaDir = lastSchemaDir;
    }
}

