/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.ant.task;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.texen.Generator;
import org.apache.velocity.util.StringUtils;
import org.asyrinx.joey.gen.core.JoeyGenerateTarget;

public class MultiTargetTexenTask
extends Task {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String ERR_MSG_FRAGMENT = ". For more information consult the velocity log, or invoke ant with the -debug flag.";
    protected String templatePath;
    protected String outputEncoding;
    protected String inputEncoding;
    protected ExtendedProperties contextProperties;
    protected boolean useClasspath;

    public void setTemplatePath(String templatePath) throws Exception {
        StringBuffer resolvedPath = new StringBuffer();
        StringTokenizer st = new StringTokenizer(templatePath, ",");
        while (st.hasMoreTokens()) {
            File fullPath = this.project.resolveFile(st.nextToken());
            resolvedPath.append(fullPath.getCanonicalPath());
            if (!st.hasMoreTokens()) continue;
            resolvedPath.append(",");
        }
        this.templatePath = resolvedPath.toString();
        System.out.println(templatePath);
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setInputEncoding(String inputEncoding) {
        this.inputEncoding = inputEncoding;
    }

    public void setContextProperties(String file) {
        String[] sources = StringUtils.split((String)file, (String)",");
        this.contextProperties = new ExtendedProperties();
        int i = 0;
        while (i < sources.length) {
            ExtendedProperties source = new ExtendedProperties();
            try {
                File fullPath = this.project.resolveFile(sources[i]);
                this.log("Using contextProperties file: " + fullPath);
                source.load((InputStream)new FileInputStream(fullPath));
            }
            catch (Exception e) {
                ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
                try {
                    InputStream inputStream = classLoader.getResourceAsStream(sources[i]);
                    if (inputStream == null) {
                        throw new BuildException("Context properties file " + sources[i] + " could not be found in the file system or on the classpath!");
                    }
                    source.load(inputStream);
                }
                catch (IOException ioe) {
                    source = null;
                }
            }
            Iterator j = source.getKeys();
            while (j.hasNext()) {
                String name = (String)j.next();
                String value = source.getString(name);
                this.contextProperties.setProperty(name, (Object)value);
            }
            ++i;
        }
    }

    public ExtendedProperties getContextProperties() {
        return this.contextProperties;
    }

    public void setUseClasspath(boolean useClasspath) {
        this.useClasspath = useClasspath;
    }

    public Context initControlContext() {
        return new VelocityContext();
    }

    protected void populateInitialContext(Context context) {
        context.put("now", (Object)new Date().toString());
    }

    protected void cleanup() throws Exception {
    }

    protected List initTargets() {
        return null;
    }

    protected void checkTargets(JoeyGenerateTarget target) {
        if (target.getControlTemplate() == null) {
            throw new BuildException("The control template needs to be defined!");
        }
        if (target.getOutputDirectory() == null) {
            throw new BuildException("The output directory needs to be defined!");
        }
        if (target.getOutputFile() == null) {
            throw new BuildException("The output file needs to be defined!");
        }
        this.log.debug((Object)("target=" + target.getTargetName()));
        this.log.debug((Object)("outputDirectory=" + target.getOutputDirectory()));
        this.log.debug((Object)("controlTemplate=" + target.getControlTemplate()));
    }

    public void execute() throws BuildException {
        List targets = this.initTargets();
        if (this.templatePath == null && !this.useClasspath) {
            throw new BuildException("The template path needs to be defined if you are not using the classpath for locating templates!");
        }
        Context c = this.initControlContext();
        this.populateInitialContext(c);
        try {
            this.prepareContextProperties(c);
        }
        catch (IOException e) {
            throw new BuildException("failed to prepareContextProperties", (Throwable)e);
        }
        VelocityEngine ve = this.initVelocityEngine();
        Iterator j = targets.iterator();
        while (j.hasNext()) {
            JoeyGenerateTarget target = (JoeyGenerateTarget)j.next();
            this.checkTargets(target);
            try {
                Generator generator = this.initGenerator();
                generator.setVelocityEngine(ve);
                generator.setOutputPath(target.getOutputDirectory());
                generator.setInputEncoding(this.inputEncoding);
                generator.setOutputEncoding(this.outputEncoding);
                this.generate(c, target, generator);
            }
            catch (BuildException e) {
                throw e;
            }
            catch (MethodInvocationException e) {
                throw new BuildException("Exception thrown by '" + e.getReferenceName() + "." + e.getMethodName() + "'" + ERR_MSG_FRAGMENT, e.getWrappedThrowable());
            }
            catch (ParseErrorException e) {
                throw new BuildException("Velocity syntax error. For more information consult the velocity log, or invoke ant with the -debug flag.", (Throwable)e);
            }
            catch (ResourceNotFoundException e) {
                throw new BuildException("Resource not found. For more information consult the velocity log, or invoke ant with the -debug flag.", (Throwable)e);
            }
            catch (Exception e) {
                throw new BuildException("Generation failed. For more information consult the velocity log, or invoke ant with the -debug flag.", (Throwable)e);
            }
        }
    }

    protected void generate(Context c, JoeyGenerateTarget target, Generator generator) throws Exception, IOException {
        File file;
        if (this.templatePath != null) {
            generator.setTemplatePath(this.templatePath);
        }
        if (!(file = new File(target.getOutputDirectory())).exists()) {
            file.mkdirs();
        }
        String path = String.valueOf(target.getOutputDirectory()) + File.separator + target.getOutputFile();
        this.log.debug((Object)("Generating to file " + path));
        Writer writer = generator.getWriter(path, this.outputEncoding);
        writer.write(generator.parse(target.getControlTemplate(), c));
        writer.flush();
        writer.close();
        generator.shutdown();
        this.cleanup();
    }

    protected Generator initGenerator() {
        return Generator.getInstance();
    }

    protected VelocityEngine initVelocityEngine() {
        VelocityEngine ve = new VelocityEngine();
        if (this.templatePath != null) {
            this.log("Using templatePath: " + this.templatePath, 3);
            ve.setProperty("file.resource.loader.path", (Object)this.templatePath);
        }
        if (this.useClasspath) {
            this.log("Using classpath");
            ve.addProperty("resource.loader", (Object)"classpath");
            ve.setProperty("classpath.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            ve.setProperty("classpath.resource.loader.cache", (Object)"false");
            ve.setProperty("classpath.resource.loader.modificationCheckInterval", (Object)"2");
        }
        try {
            ve.init();
        }
        catch (Exception e) {
            throw new BuildException("VelocityEngine#init() failed . For more information consult the velocity log, or invoke ant with the -debug flag.", (Throwable)e);
        }
        return ve;
    }

    protected void prepareContextProperties(Context c) throws IOException {
        if (this.contextProperties != null) {
            Iterator i = this.contextProperties.getKeys();
            while (i.hasNext()) {
                String property = (String)i.next();
                String value = this.contextProperties.getString(property);
                try {
                    c.put(property, (Object)new Integer(value));
                }
                catch (NumberFormatException nfe) {
                    String booleanString = this.contextProperties.testBoolean(value);
                    if (booleanString != null) {
                        c.put(property, (Object)new Boolean(booleanString));
                        continue;
                    }
                    if (property.endsWith("file.contents")) {
                        value = StringUtils.fileContentsToString((String)this.project.resolveFile(value).getCanonicalPath());
                        property = property.substring(0, property.indexOf("file.contents") - 1);
                    }
                    c.put(property, (Object)value);
                }
            }
        }
    }
}

