/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.ant.task;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import org.asyrinx.brownie.core.lang.ObjectUtils;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.joey.gen.ant.task.ModificationView;
import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.ElementSet;
import org.asyrinx.joey.gen.model.EnumerationEntry;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;
import org.asyrinx.joey.gen.model.rdb.Index;
import org.asyrinx.joey.gen.model.rdb.IndexEntry;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;
import org.asyrinx.joey.gen.model.rdb.Table;
import org.asyrinx.joey.gen.model.rdb.TablePattern;
import org.asyrinx.joey.gen.model.rdb.TablePatternParam;

class ShowModification {
    private final boolean showNoChange;
    private final boolean showDeleted;
    private final boolean showAppended;
    private PrintWriter writer = this.getWriter(this.getOutputStream());
    final ShowClosure lastBaseClosure = new ShowClosure(){

        public void invoke(ModificationView view, String header, Element lastElement, Element currElement) {
            if (currElement == null) {
                if (ShowModification.this.isShowDeleted()) {
                    ShowModification.this.printElementName("-", header, lastElement);
                }
            } else if (currElement.equals(lastElement)) {
                if (ShowModification.this.isShowNoChange()) {
                    ShowModification.this.printElementName(" ", header, lastElement);
                }
                if (view != null) {
                    view.show(currElement, lastElement);
                }
            } else {
                ShowModification.this.printElementName("!", header, lastElement);
                if (view != null) {
                    view.show(currElement, lastElement);
                }
            }
        }
    };
    final ShowClosure currentBaseClosure = new ShowClosure(){

        public void invoke(ModificationView view, String header, Element lastElement, Element currElement) {
            if (lastElement == null && ShowModification.this.isShowAppended()) {
                ShowModification.this.printElementName("+", header, currElement);
            }
        }
    };
    final ModificationView databasesView = new ModificationView(){

        public void show(Element current, Element last) {
            Databases c = (Databases)current;
            Databases l = (Databases)last;
            ShowModification.this.printPropLine((Element)c, "options", (Object)l.getOptions(), (Object)c.getOptions());
            ShowModification.this.showModification(ShowModification.this.databaseView, "database", c.getDatabases(), l.getDatabases());
        }
    };
    final ModificationView databaseView = new ModificationView(){

        public void show(Element current, Element last) {
            Database c = (Database)current;
            Database l = (Database)last;
            ShowModification.this.printPropLine((Element)c, "options", (Object)l.getOptions(), (Object)c.getOptions());
            ShowModification.this.showModification(ShowModification.this.enumView, "enum", c.getEnumerations(), l.getEnumerations());
            ShowModification.this.showModification(ShowModification.this.tableView, "table", c.getTables(), l.getTables());
        }
    };
    final ModificationView enumView = new ModificationView(){

        public void show(Element current, Element last) {
            RdbEnumeration c = (RdbEnumeration)current;
            RdbEnumeration l = (RdbEnumeration)last;
            ShowModification.this.printPropLine((Element)c, "options", (Object)l.getOptions(), (Object)c.getOptions());
            ShowModification.this.showModification(ShowModification.this.enumEntryView, "enum-entry", c, l);
        }
    };
    final ModificationView enumEntryView = new ModificationView(){

        public void show(Element current, Element last) {
            EnumerationEntry c = (EnumerationEntry)current;
            EnumerationEntry l = (EnumerationEntry)last;
            ShowModification.this.printPropLine((Element)c, "value", (Object)l.getValue(), (Object)c.getValue());
            ShowModification.this.printPropLine((Element)c, "options", (Object)l.getOptions(), (Object)c.getOptions());
        }
    };
    final ModificationView tableView = new ModificationView(){

        public void show(Element current, Element last) {
            Table c = (Table)current;
            Table l = (Table)last;
            ShowModification.this.printPropLine((Element)c, "extends", (Object)l.getExtends(), (Object)c.getExtends());
            ShowModification.this.printPropLine((Element)c, "captionColumn", (Object)l.getCaptionColumn(), (Object)c.getCaptionColumn());
            ShowModification.this.printPropLine((Element)c, "options", (Object)l.getOptions(), (Object)c.getOptions());
            ShowModification.this.showModification(ShowModification.this.columnView, "column", c.getColumns(), l.getColumns());
            ShowModification.this.showModification(ShowModification.this.fkView, "foreignKey", c.getForeignKeys(), l.getForeignKeys());
            ShowModification.this.showModification(ShowModification.this.indexView, "index", c.getIndexes(), l.getIndexes());
            ShowModification.this.showModification(ShowModification.this.patternView, "pattern", c.getPatterns(), l.getPatterns());
        }
    };
    final ModificationView columnView = new ModificationView(){

        public void show(Element current, Element last) {
            Column c = (Column)current;
            Column l = (Column)last;
            ShowModification.this.printPropLine((Element)c, "type", (Object)l.getType(), (Object)c.getType());
            ShowModification.this.printPropLine((Element)c, "size", (Object)l.getSize(), (Object)c.getSize());
            ShowModification.this.printPropLine((Element)c, "required", l.isRequired(), c.isRequired());
            ShowModification.this.printPropLine((Element)c, "primaryKey", l.isPrimaryKey(), c.isPrimaryKey());
            ShowModification.this.printPropLine((Element)c, "defaultValue", (Object)l.getDefaultValue(), (Object)c.getDefaultValue());
            ShowModification.this.printPropLine((Element)c, "enum", (Object)l.getEnum(), (Object)c.getEnum());
            ShowModification.this.printPropLine((Element)c, "options", (Object)l.getOptions(), (Object)c.getOptions());
        }
    };
    final ModificationView fkView = new ModificationView(){

        public void show(Element current, Element last) {
            ForeignKey c = (ForeignKey)current;
            ForeignKey l = (ForeignKey)last;
            ShowModification.this.printPropLine((Element)c, "foreign", (Object)l.getForeign(), (Object)c.getForeign());
            ShowModification.this.printPropLine((Element)c, "type", (Object)l.getType(), (Object)c.getType());
            ShowModification.this.printPropLine((Element)c, "cascade", (Object)l.getCascade(), (Object)c.getCascade());
            ShowModification.this.printPropLine((Element)c, "options", (Object)l.getOptions(), (Object)c.getOptions());
            ShowModification.this.showModification(ShowModification.this.fkEntryView, "reference", c, l);
        }
    };
    final ModificationView fkEntryView = new ModificationView(){

        public void show(Element current, Element last) {
            ForeignKeyEntry c = (ForeignKeyEntry)current;
            ForeignKeyEntry l = (ForeignKeyEntry)last;
            ShowModification.this.printPropLine((Element)c, "local", (Object)l.getLocal(), (Object)c.getLocal());
            ShowModification.this.printPropLine((Element)c, "foreign", (Object)l.getForeign(), (Object)c.getForeign());
            ShowModification.this.printPropLine((Element)c, "options", (Object)l.getOptions(), (Object)c.getOptions());
        }
    };
    final ModificationView indexView = new ModificationView(){

        public void show(Element current, Element last) {
            Index c = (Index)current;
            Index l = (Index)last;
            ShowModification.this.printPropLine((Element)c, "unique", l.isUnique(), c.isUnique());
            ShowModification.this.printPropLine((Element)c, "options", (Object)l.getOptions(), (Object)c.getOptions());
            ShowModification.this.showModification(ShowModification.this.indexEntryView, "index-column", c, l);
        }
    };
    final ModificationView uniqueView = new ModificationView(){

        public void show(Element current, Element last) {
            Index c = (Index)current;
            Index l = (Index)last;
            ShowModification.this.printPropLine((Element)c, "unique", l.isUnique(), c.isUnique());
            ShowModification.this.printPropLine((Element)c, "options", (Object)l.getOptions(), (Object)c.getOptions());
            ShowModification.this.showModification(ShowModification.this.indexEntryView, "unique-column", c, l);
        }
    };
    final ModificationView indexEntryView = new ModificationView(){

        public void show(Element current, Element last) {
            IndexEntry c = (IndexEntry)current;
            IndexEntry l = (IndexEntry)last;
            ShowModification.this.printPropLine((Element)c, "options", (Object)l.getOptions(), (Object)c.getOptions());
        }
    };
    final ModificationView patternView = new ModificationView(){

        public void show(Element current, Element last) {
            TablePattern c = (TablePattern)current;
            TablePattern l = (TablePattern)last;
            ShowModification.this.printPropLine((Element)c, "options", (Object)l.getOptions(), (Object)c.getOptions());
            ShowModification.this.showModification(ShowModification.this.patternParamView, "param", c, l);
        }
    };
    final ModificationView patternParamView = new ModificationView(){

        public void show(Element current, Element last) {
            TablePatternParam c = (TablePatternParam)current;
            TablePatternParam l = (TablePatternParam)last;
            ShowModification.this.printPropLine((Element)c, "value", (Object)l.getValue(), (Object)c.getValue());
            ShowModification.this.printPropLine((Element)c, "options", (Object)l.getOptions(), (Object)c.getOptions());
        }
    };

    public ShowModification(boolean showNoChange, boolean showDeleted, boolean showAppended) {
        this.showNoChange = showNoChange;
        this.showDeleted = showDeleted;
        this.showAppended = showAppended;
    }

    public void execute(Databases currentModel, Databases lastModel) {
        this.databasesView.show(currentModel, lastModel);
    }

    protected void showModification(ModificationView view, String header, ElementSet current, ElementSet last) {
        if (ObjectUtils.equals((Object)current, (Object)last) && !this.isShowNoChange()) {
            return;
        }
        if (current.careChildOrder()) {
            this.showModificationByOrder(view, header, current, last);
        } else {
            this.showModificationByName(view, header, current, last);
        }
    }

    protected void showModificationByOrder(ModificationView view, String header, ElementSet current, ElementSet last) {
        Element currElement;
        Element lastElement;
        int i = 0;
        while (i < last.size()) {
            lastElement = last.getElement(i);
            currElement = current.getElement(i);
            this.lastBaseClosure.invoke(view, header, lastElement, currElement);
            ++i;
        }
        if (last.size() >= current.size()) {
            return;
        }
        i = last.size();
        while (i < current.size()) {
            lastElement = null;
            currElement = current.getElement(i);
            this.currentBaseClosure.invoke(view, header, lastElement, currElement);
            ++i;
        }
    }

    protected void showModificationByName(ModificationView view, String header, ElementSet current, ElementSet last) {
        Iterator i = last.iterator();
        while (i.hasNext()) {
            Element lastElement = (Element)i.next();
            Element currElement = current.getElement(lastElement.getName());
            this.lastBaseClosure.invoke(view, header, lastElement, currElement);
        }
        i = current.iterator();
        while (i.hasNext()) {
            Element currElement = (Element)i.next();
            Element lastElement = last.getElement(currElement.getName());
            this.currentBaseClosure.invoke(view, header, lastElement, currElement);
        }
    }

    void printElementName(String mark, String header, Element element) {
        if (element != null) {
            this.writer.println(String.valueOf(mark) + " " + StringUtils.repeat((String)" ", (int)((element.getAncestorDepth() - 1) * 4)) + StringUtils.padTail((String)header, (String)" ", (int)12) + " : " + element.getName());
        } else {
            this.writer.println(String.valueOf(mark) + " " + StringUtils.repeat((String)" ", (int)12) + StringUtils.padTail((String)header, (String)" ", (int)12) + " : " + "null");
        }
    }

    void printPropLine(Element element, String name, boolean last, boolean current) {
        this.printPropLine(element, name, (Object)new Boolean(last), (Object)new Boolean(current));
    }

    void printPropLine(Element element, String name, Object last, Object current) {
        int indent = element.getAncestorDepth() * 4;
        if (last instanceof Map && current instanceof Map) {
            this.printPropLineAsMap(indent + 4, name, (Map)last, (Map)current);
        } else {
            this.printPropLine(indent, name, last, current);
        }
    }

    void printPropLine(int indent, String name, Object last, Object current) {
        if (ObjectUtils.equals((Object)last, (Object)current)) {
            if (!this.isShowNoChange()) {
                return;
            }
            this.writer.println("  " + StringUtils.repeat((String)" ", (int)indent) + name + " : " + last);
        } else {
            this.writer.println("! " + StringUtils.repeat((String)" ", (int)indent) + name + " : [" + last + "] -> [" + current + "]");
        }
    }

    void printPropLineAsMap(int indent, String name, Map last, Map current) {
        Object currValue;
        Object lastValue;
        Object key;
        if (ObjectUtils.equals((Object)last, (Object)current)) {
            if (!this.isShowNoChange()) {
                return;
            }
            this.writer.println("  " + StringUtils.repeat((String)" ", (int)indent) + name + " : ");
        } else {
            this.writer.println("! " + StringUtils.repeat((String)" ", (int)indent) + name + " : ");
        }
        Iterator i = last.keySet().iterator();
        while (i.hasNext()) {
            key = i.next();
            lastValue = last.get(key);
            currValue = current.get(key);
            this.printPropLine(indent + 4, key.toString(), lastValue, currValue);
        }
        i = current.keySet().iterator();
        while (i.hasNext()) {
            key = i.next();
            if (last.containsKey(key)) continue;
            lastValue = last.get(key);
            currValue = current.get(key);
            this.printPropLine(indent + 4, key.toString(), lastValue, currValue);
        }
    }

    protected OutputStream getOutputStream() {
        return System.out;
    }

    protected PrintWriter getWriter(OutputStream stream) {
        return new PrintWriter(stream){

            public void println(String x) {
                System.out.println(x);
            }
        };
    }

    public boolean isShowAppended() {
        return this.showAppended;
    }

    public boolean isShowDeleted() {
        return this.showDeleted;
    }

    public boolean isShowNoChange() {
        return this.showNoChange;
    }

    interface ShowClosure {
        public void invoke(ModificationView var1, String var2, Element var3, Element var4);
    }
}

