/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.command.java;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.joey.gen.command.java.JavaCommand;
import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.java.Entity;
import org.asyrinx.joey.gen.model.java.Property;
import org.asyrinx.joey.gen.model.java.Reference;

public class CheckNameOfProperty
extends JavaCommand {
    public void visit(Entity entity) {
        Reference reference;
        String propertyName;
        HashMap checkedNames = new HashMap();
        Iterator i = entity.getPropertiesAll().iterator();
        while (i.hasNext()) {
            Element property = (Element)i.next();
            propertyName = property.getName();
            this.checkName(checkedNames, property, propertyName);
        }
        i = entity.getReferencesAll().iterator();
        while (i.hasNext()) {
            reference = (Reference)i.next();
            propertyName = reference.getPropertyNameInLocal();
            this.checkName(checkedNames, reference, propertyName);
        }
        i = entity.getReferredAll().iterator();
        while (i.hasNext()) {
            reference = (Reference)i.next();
            propertyName = reference.getPropertyNameInReferred();
            this.checkName(checkedNames, reference, propertyName);
        }
    }

    private void checkName(Map checkedNames, Element element, String propertyName) {
        Element duplicated;
        if (StringUtils.isEmpty((String)propertyName)) {
            this.addError(String.valueOf(element.getFullName()) + "(" + element.getOriginal() + ")" + " has no property name");
        }
        if ((duplicated = (Element)checkedNames.get(propertyName)) != null && this.isDuplicated(element, duplicated)) {
            this.addError("propertyName=" + propertyName + "  " + element + "(" + element.getOriginal() + ")" + " has duplicated property name with " + duplicated + "(" + duplicated.getOriginal() + ")");
        }
        checkedNames.put(propertyName, element);
    }

    private boolean isDuplicated(Element element1, Element element2) {
        if (element1 == element2) {
            return false;
        }
        if (element1 instanceof Property && element2 instanceof Property) {
            if (this.isExtended((Property)element1, (Property)element2)) {
                return false;
            }
            if (this.isExtended((Property)element2, (Property)element1)) {
                return false;
            }
        }
        return true;
    }

    private boolean isExtended(Property property1, Property property2) {
        if (!property1.isExtended()) {
            return false;
        }
        return property1.getParent().getSuperClass() == property2.getParent();
    }
}

