/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.command.rdb;

import java.util.HashSet;
import java.util.Iterator;
import org.asyrinx.joey.gen.command.rdb.RdbCommand;
import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;
import org.asyrinx.joey.gen.model.rdb.Table;

public abstract class CheckNameDuplication
extends RdbCommand {
    protected abstract Iterator getTargets(Element var1);

    public void checkDuplication(Element targetParent) {
        HashSet<String> elementNames = new HashSet<String>();
        Iterator i = this.getTargets(targetParent);
        while (i.hasNext()) {
            Element element = (Element)i.next();
            if (elementNames.contains(element.getName())) {
                this.addError(element, String.valueOf(element.getName()) + " is duplicated.");
            }
            elementNames.add(element.getName());
        }
    }

    public static class Tables
    extends CheckNameDuplication {
        public void visit(Database database) {
            super.checkDuplication(database);
        }

        protected Iterator getTargets(Element targetParent) {
            return ((Database)targetParent).getTables().iterator();
        }
    }

    public static class Columns
    extends CheckNameDuplication {
        public void visit(Table table) {
            super.checkDuplication(table);
        }

        protected Iterator getTargets(Element targetParent) {
            return ((Table)targetParent).getColumns().iterator();
        }
    }

    public static class Enumerations
    extends CheckNameDuplication {
        public void visit(Database database) {
            super.checkDuplication(database);
        }

        protected Iterator getTargets(Element targetParent) {
            return ((Database)targetParent).getEnumerations().iterator();
        }
    }

    public static class EnumerationEntries
    extends CheckNameDuplication {
        public void visit(RdbEnumeration enumeration) {
            super.checkDuplication(enumeration);
        }

        protected Iterator getTargets(Element targetParent) {
            return ((RdbEnumeration)targetParent).iterator();
        }
    }
}

