/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.command.rdb;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.command.rdb.RdbCommand;
import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;
import org.asyrinx.joey.gen.model.rdb.Table;

public class CopyAncestorOption
extends RdbCommand {
    protected final Object optionKey;

    public CopyAncestorOption(Object optionKey) {
        this.optionKey = optionKey;
    }

    public void visit(Table table) {
        table.getOptions().put(this.optionKey, this.getOptionValue(table));
    }

    public void visit(RdbEnumeration enumeration) {
        enumeration.getOptions().put(this.optionKey, this.getOptionValue(enumeration));
    }

    public String getOptionValue(Element element) {
        String result = this.getAncestorOptionValue(element);
        if (result != null) {
            return result;
        }
        return element.getParentElement() == null ? null : element.getParentElement().getName();
    }

    protected String getAncestorOptionValue(Element element) {
        String result = this.getValue(element.getOptions());
        if (!StringUtils.isEmpty((String)result)) {
            return result;
        }
        if (element.getParentElement() != null) {
            return this.getAncestorOptionValue(element.getParentElement());
        }
        return null;
    }

    private String getValue(Map options) {
        Object result = options.get(this.optionKey);
        return result != null ? result.toString() : null;
    }
}

