/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.command.rdb;

import java.util.Iterator;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.command.rdb.RdbCommand;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Table;

public class PrepareCaptionColumn
extends RdbCommand {
    final Predicate[] predicates = new Predicate[]{new Predicate(){

        public boolean evaluate(Object obj) {
            if (!(obj instanceof Column)) {
                throw new UnsupportedOperationException();
            }
            Column column = (Column)obj;
            return column.isCaption();
        }
    }, new Predicate(){

        public boolean evaluate(Object obj) {
            if (!(obj instanceof Column)) {
                throw new UnsupportedOperationException();
            }
            Column column = (Column)obj;
            return "name".equalsIgnoreCase(column.getName());
        }
    }, new Predicate(){

        public boolean evaluate(Object obj) {
            if (!(obj instanceof Column)) {
                throw new UnsupportedOperationException();
            }
            Column column = (Column)obj;
            if (StringUtils.isEmpty((String)column.getName())) {
                return false;
            }
            return column.getName().toLowerCase().endsWith("name");
        }
    }};

    public void visit(Table table) {
        int i = 0;
        while (i < this.predicates.length) {
            Column column = this.findColumn(table, this.predicates[i]);
            if (column != null) {
                table.setCaptionColumn(column);
                return;
            }
            ++i;
        }
    }

    private Column findColumn(Table table, Predicate predicate) {
        Iterator i = table.getColumns().iterator();
        while (i.hasNext()) {
            Column column = (Column)i.next();
            if (!predicate.evaluate((Object)column)) continue;
            return column;
        }
        return null;
    }
}

