/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.command.rdb;

import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.joey.gen.command.rdb.RdbCommand;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyType;
import org.asyrinx.joey.gen.model.rdb.Table;

public class PrepareColumnFk
extends RdbCommand {
    public void visit(Column column) {
        ForeignKeyType foreignKeyType = ForeignKeyType.get(column.getFkType());
        this.buildFk(column, column.getFk(), foreignKeyType);
    }

    private ForeignKey buildFk(Column column, String foreignColumnName, ForeignKeyType fkType) {
        if (fkType == ForeignKeyType.EXTENDS) {
            throw new UnsupportedOperationException("fkType must be " + ForeignKeyType.NORMAL.getName() + " or " + ForeignKeyType.BIDIRECTION.getName());
        }
        if (StringUtils.isEmpty((String)foreignColumnName)) {
            return null;
        }
        Table localTable = column.getParent();
        Database db = localTable.getParent();
        Column fkCol = db.getColumn(foreignColumnName);
        if (fkCol == null) {
            this.addError(column, "cannot find:" + foreignColumnName);
            return null;
        }
        ForeignKey foreignKey = new ForeignKey(localTable, fkCol.getParent().getName());
        foreignKey.setLabel(column.getLabel());
        foreignKey.setType(fkType);
        foreignKey.setCascade(column.getFkCascade());
        new ForeignKeyEntry(foreignKey, column.getName(), fkCol.getName());
        this.log(foreignKey, "create FK from " + column.getFullName());
        return foreignKey;
    }
}

