/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.command.rdb2java.standard;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.joey.gen.command.rdb2java.NamingStrategy;
import org.asyrinx.joey.gen.command.rdb2java.TypeMappingStrategy;
import org.asyrinx.joey.gen.command.rdb2java.standard.BasicNaming;
import org.asyrinx.joey.gen.command.rdb2java.standard.BasicTypeMapping;
import org.asyrinx.joey.gen.command.rdb2java.standard.JavaTypeResolver;
import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.EnumerationEntry;
import org.asyrinx.joey.gen.model.java.AppDomain;
import org.asyrinx.joey.gen.model.java.Entity;
import org.asyrinx.joey.gen.model.java.JavaEnumeration;
import org.asyrinx.joey.gen.model.java.Property;
import org.asyrinx.joey.gen.model.java.classes.JoeyRuntimeClass;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;
import org.asyrinx.joey.gen.model.rdb.Table;
import org.asyrinx.joey.gen.model.rdb.visitor.RdbTopDownVisitor;
import org.asyrinx.joey.gen.model.rdb.visitor.RdbVisitorMock;

class JavaElementBuilder
extends RdbVisitorMock {
    private AppDomain appDomain = null;
    private JavaTypeResolver resolver = null;
    final Log log = LogFactory.getLog(this.getClass());
    final Map java2rdb = new HashMap(){

        public Object put(Object key, Object value) {
            if (this.containsKey(key)) {
                JavaElementBuilder.this.log.warn((Object)("java2rdb: key'" + key + "' was overriden."));
            }
            return super.put(key, value);
        }
    };
    private final Map rdb2java = new HashMap(){

        private String toName(Object obj) {
            if (obj instanceof Element) {
                return ((Element)obj).getFullName();
            }
            return String.valueOf(obj);
        }

        public Object remove(Object key) {
            Object value = super.remove(key);
            if (value != null) {
                JavaElementBuilder.this.java2rdb.remove(value);
            }
            return value;
        }

        public Object put(Object key, Object value) {
            if (key == null) {
                JavaElementBuilder.this.log.warn((Object)("rdb2java: key was null. value =" + this.toName(value)));
            }
            if (value == null) {
                JavaElementBuilder.this.log.warn((Object)("rdb2java: value was null. key =" + this.toName(key)));
            }
            if (this.containsKey(key)) {
                JavaElementBuilder.this.log.warn((Object)("rdb2java: key'" + key + "' was overriden."));
            }
            JavaElementBuilder.this.java2rdb.put(value, key);
            return super.put(key, value);
        }
    };
    private NamingStrategy naming = new BasicNaming();
    private TypeMappingStrategy typeMapping = new BasicTypeMapping();

    private void prepareEmbedded() {
        this.rdb2java.put(JoeyRuntimeClass.RDB_BOOLEAN_ENUM, JoeyRuntimeClass.JAVA_BOOLEAN_ENUM);
        this.resolver.addType(JoeyRuntimeClass.JAVA_BOOLEAN_ENUM.getFullName(), JoeyRuntimeClass.JAVA_BOOLEAN_ENUM);
    }

    public void execute(Databases databases, AppDomain domain, JavaTypeResolver typeResolver) {
        this.appDomain = domain;
        this.resolver = typeResolver;
        this.prepareEmbedded();
        RdbTopDownVisitor topDownVisitor = new RdbTopDownVisitor(this);
        topDownVisitor.visit(databases);
    }

    public void visit(RdbEnumeration rdbEnumeration) {
        JavaEnumeration result = new JavaEnumeration(this.appDomain, rdbEnumeration.getName(), rdbEnumeration.getValueType());
        result.setOriginal(rdbEnumeration);
        result.setLabel(rdbEnumeration.getLabel());
        result.setDescription(rdbEnumeration.getDescription());
        result.setValueTypeObj(this.typeMapping.toJavaType(rdbEnumeration.getValueType()));
        result.getOptions().putAll(rdbEnumeration.getOptions());
        Iterator i = rdbEnumeration.iterator();
        while (i.hasNext()) {
            EnumerationEntry entry = (EnumerationEntry)i.next();
            try {
                result.add((EnumerationEntry)entry.clone());
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                throw new UnsupportedOperationException(e.getMessage());
            }
        }
        this.rdb2java.put(rdbEnumeration, result);
        this.resolver.addType(result.getFullName(), result);
    }

    public void visit(Table table) {
        Entity result = new Entity(this.appDomain);
        result.setOriginal(table);
        result.setName(this.naming.toClassName(table));
        result.setDescription(table.getDescription());
        result.setLabel(table.getLabel());
        result.getOptions().putAll(table.getOptions());
        result.setInterfaces(StringUtils.defaultString(table.getOptions().get("interfaces")));
        this.rdb2java.put(table, result);
        this.resolver.addType(result.getFullName(), result);
    }

    public void visit(Column column) {
        JavaEnumeration enumeration;
        Entity owner = (Entity)this.rdb2java.get(column.getParent());
        Property result = new Property(owner);
        result.setOriginal(column);
        result.setName(this.naming.toPropertyName(column));
        result.setType(this.typeMapping.toJavaType(column));
        result.setPrimaryKey(column.isPrimaryKey());
        if (result.getType() == null && (enumeration = this.appDomain.getEnumerations().getEnumeration(column.getType())) != null) {
            result.setType(enumeration);
        }
        result.setDefaultValue(column.getDefaultValue());
        result.setDescription(column.getDescription());
        result.setLabel(column.getLabel());
        result.setRequired(column.isRequired());
        result.setMaxLength(column.getSizeAsInt());
        result.setExtended(column.isExtended());
        result.getOptions().putAll(column.getOptions());
        this.rdb2java.put(column, result);
    }

    public NamingStrategy getNaming() {
        return this.naming;
    }

    public void setNaming(NamingStrategy naming) {
        this.naming = naming;
    }

    public TypeMappingStrategy getTypeMapping() {
        return this.typeMapping;
    }

    public void setTypeMapping(TypeMappingStrategy typeMapping) {
        this.typeMapping = typeMapping;
    }

    public Map getRdb2java() {
        return this.rdb2java;
    }

    public Map getJava2rdb() {
        return this.java2rdb;
    }
}

