/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.command.rdb2java.standard;

import java.util.Iterator;
import java.util.Map;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.joey.gen.model.java.Entity;
import org.asyrinx.joey.gen.model.java.EntityKey;
import org.asyrinx.joey.gen.model.java.EntityKeyEntry;
import org.asyrinx.joey.gen.model.java.EntityKeyType;
import org.asyrinx.joey.gen.model.java.Property;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.Index;
import org.asyrinx.joey.gen.model.rdb.IndexEntry;
import org.asyrinx.joey.gen.model.rdb.Table;
import org.asyrinx.joey.gen.model.rdb.Unique;
import org.asyrinx.joey.gen.model.rdb.visitor.RdbTopDownVisitor;
import org.asyrinx.joey.gen.model.rdb.visitor.RdbVisitorMock;

class JavaIndexKeyBuilder
extends RdbVisitorMock {
    private Map rdb2java = null;

    JavaIndexKeyBuilder() {
    }

    public void execute(Databases databases, Map rdb2javaMap) {
        this.rdb2java = rdb2javaMap;
        new RdbTopDownVisitor(this).visit(databases);
    }

    public void visit(Index index) {
        EntityKey key = this.buildEntityKey(index);
        key.setKeyType(EntityKeyType.INDEX);
    }

    public void visit(Unique unique) {
        EntityKey key = this.buildEntityKey(unique);
        key.setKeyType(EntityKeyType.UNIQUE);
    }

    private EntityKey buildEntityKey(Index index) {
        Table table = index.getParent();
        Entity ownerClass = (Entity)this.rdb2java.get(table);
        EntityKey result = new EntityKey(ownerClass);
        result.setOriginal(index);
        Iterator i = index.iterator();
        while (i.hasNext()) {
            IndexEntry entry = (IndexEntry)i.next();
            Column column = entry.getColumn();
            Property property = (Property)this.rdb2java.get(column);
            new EntityKeyEntry(result, property);
        }
        result.setName("key" + this.concatEntryNames(index));
        return result;
    }

    private String concatEntryNames(Index index) {
        StringBuffer result = new StringBuffer();
        Iterator i = index.iterator();
        while (i.hasNext()) {
            IndexEntry entry = (IndexEntry)i.next();
            Column column = entry.getColumn();
            Property property = (Property)this.rdb2java.get(column);
            result.append(StringUtils.capitalize((String)property.getName()));
        }
        return result.toString();
    }
}

