/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.command.rdb2java.standard;

import java.util.Iterator;
import java.util.Map;
import org.asyrinx.joey.gen.model.java.Entity;
import org.asyrinx.joey.gen.model.java.EntityKey;
import org.asyrinx.joey.gen.model.java.EntityKeyEntry;
import org.asyrinx.joey.gen.model.java.EntityKeyType;
import org.asyrinx.joey.gen.model.java.Property;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.Table;
import org.asyrinx.joey.gen.model.rdb.visitor.RdbTopDownVisitor;
import org.asyrinx.joey.gen.model.rdb.visitor.RdbVisitorMock;

class JavaPrimaryKeyBuilder
extends RdbVisitorMock {
    private Map rdb2java = null;

    JavaPrimaryKeyBuilder() {
    }

    public void execute(Databases databases, Map rdb2javaMap) {
        this.rdb2java = rdb2javaMap;
        new RdbTopDownVisitor(this).visit(databases);
    }

    public void visit(Table table) {
        Entity ownerClass = (Entity)this.rdb2java.get(table);
        if (table.getExtendsTable() != null) {
            return;
        }
        EntityKey pk = new EntityKey(ownerClass, "pk");
        pk.setKeyType(EntityKeyType.PK);
        pk.setName("primaryKey");
        Iterator i = table.getColumns().iterator();
        while (i.hasNext()) {
            Column column = (Column)i.next();
            if (!column.isPrimaryKey()) continue;
            Property property = (Property)this.rdb2java.get(column);
            new EntityKeyEntry(pk, property);
        }
    }
}

