/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.command.rdb2java.standard;

import java.util.Iterator;
import java.util.Map;
import org.asyrinx.joey.gen.command.rdb.RdbCommand;
import org.asyrinx.joey.gen.hibernate.Cascade;
import org.asyrinx.joey.gen.model.java.Entity;
import org.asyrinx.joey.gen.model.java.Property;
import org.asyrinx.joey.gen.model.java.Reference;
import org.asyrinx.joey.gen.model.java.ReferenceEntry;
import org.asyrinx.joey.gen.model.java.ReferenceType;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyType;
import org.asyrinx.joey.gen.model.rdb.Table;

class JavaReferenceBuilder
extends RdbCommand {
    private Map rdb2java = null;

    JavaReferenceBuilder() {
    }

    public void execute(Databases databases, Map rdb2javaMap) {
        this.rdb2java = rdb2javaMap;
        super.execute(databases);
    }

    public void visit(ForeignKey foreignKey) {
        if (foreignKey.getType() == ForeignKeyType.EXTENDS) {
            this.rdb2java.remove(foreignKey);
            return;
        }
        Table localTable = foreignKey.getParent();
        Table foreignTable = foreignKey.getForeignTable();
        Entity ownerClass = (Entity)this.rdb2java.get(localTable);
        Entity referenceClass = (Entity)this.rdb2java.get(foreignTable);
        Reference result = new Reference(ownerClass);
        result.setOriginal(foreignKey);
        result.setType(ReferenceType.get(foreignKey.getType().getName()));
        result.setCascade(Cascade.get(foreignKey.getCascade()));
        result.setLabel(foreignKey.getLabel());
        result.setReferenceClass(referenceClass);
        Iterator i = foreignKey.iterator();
        while (i.hasNext()) {
            ForeignKeyEntry entry = (ForeignKeyEntry)i.next();
            Property local = (Property)this.rdb2java.get(entry.getLocalColumn());
            Property foreign = (Property)this.rdb2java.get(entry.getForeignColumn());
            if (local == null) {
                this.addError(foreignKey, "property for column '" + entry.getLocal() + "'" + entry.getLocalColumn() + " not found.");
            }
            if (foreign == null) {
                this.addError(foreignKey, "column '" + entry.getForeign() + "' not found.");
            }
            new ReferenceEntry(result, local, foreign);
        }
        this.rdb2java.put(foreignKey, result);
    }
}

