/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.core.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.asyrinx.joey.gen.core.BizLogicDistiller;

public class BizLogicDistillerByLine
implements BizLogicDistiller {
    private final String bizLogicMarkerBegin;
    private final String bizLogicMarkerEnd;

    public BizLogicDistillerByLine(String bizLogicMarkerBegin, String bizLogicMarkerEnd) {
        this.bizLogicMarkerBegin = bizLogicMarkerBegin;
        this.bizLogicMarkerEnd = bizLogicMarkerEnd;
    }

    public String getBizLogicMarkerBegin() {
        return this.bizLogicMarkerBegin;
    }

    public String getBizLogicMarkerEnd() {
        return this.bizLogicMarkerEnd;
    }

    public String distill(File source) throws IOException {
        FileInputStream fis = new FileInputStream(source);
        BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
        ArrayList<StringBuffer> bufferes = new ArrayList<StringBuffer>();
        StringBuffer buffer = this.distillPart(reader);
        while (buffer != null) {
            bufferes.add(buffer);
            buffer = this.distillPart(reader);
        }
        return this.concatBuffers(bufferes);
    }

    private String concatBuffers(List buffers) {
        StringBuffer result = new StringBuffer();
        Iterator i = buffers.iterator();
        while (i.hasNext()) {
            StringBuffer buffer = (StringBuffer)i.next();
            result.append(buffer).append("\n");
        }
        return result.toString();
    }

    private StringBuffer distillPart(BufferedReader reader) throws IOException {
        if (!this.skipTo(reader, this.getBizLogicMarkerBegin())) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        if (!this.appendTo(reader, buffer, this.getBizLogicMarkerEnd())) {
            return null;
        }
        return buffer;
    }

    private boolean skipTo(BufferedReader reader, String match) throws IOException {
        String line = reader.readLine();
        while (line != null) {
            if (line.trim().equals(match)) {
                return true;
            }
            line = reader.readLine();
        }
        return false;
    }

    private boolean appendTo(BufferedReader reader, StringBuffer dest, String match) throws IOException {
        String line = reader.readLine();
        while (line != null) {
            if (line.trim().equals(match)) {
                return true;
            }
            dest.append(line).append("\n");
            line = reader.readLine();
        }
        return false;
    }
}

