/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.core.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.context.Context;
import org.asyrinx.brownie.core.io.FileNameUtils;
import org.asyrinx.joey.gen.core.BizLogicDistiller;
import org.asyrinx.joey.gen.core.GenerationQuery;
import org.asyrinx.joey.gen.core.JoeyGenRuntimeException;

public class BizLogicDistillerComposite
implements BizLogicDistiller,
GenerationQuery {
    private final Map distillers = new HashMap();
    final Log log = LogFactory.getLog(this.getClass());

    public boolean canGenerate(String inputTemplate, File outputFile, Context context) {
        String distilled;
        context.put("bizLogic", (Object)"");
        if (outputFile == null) {
            return true;
        }
        if (!outputFile.exists()) {
            return true;
        }
        String ext = FileNameUtils.getExtension((String)outputFile.getName()).toLowerCase();
        if (!this.containsDistiller(ext)) {
            return false;
        }
        try {
            distilled = this.distill(outputFile);
        }
        catch (IOException e) {
            throw new JoeyGenRuntimeException(e);
        }
        if (distilled != null && !"".equals(distilled.trim())) {
            context.put("bizLogic", (Object)distilled);
        }
        this.log.debug((Object)("canGenerate context.hashCode=" + context.hashCode()));
        this.log.debug((Object)("canGenerate context['bizLogic']=" + context.get("bizLogic")));
        return true;
    }

    public String distill(File source) throws IOException {
        String ext = FileNameUtils.getExtension((String)source.getName());
        BizLogicDistiller distiller = (BizLogicDistiller)this.distillers.get(ext);
        if (distiller != null) {
            return distiller.distill(source);
        }
        return "";
    }

    public boolean containsDistiller(String ext) {
        return this.distillers.containsKey(ext.toLowerCase());
    }

    public void put(String ext, BizLogicDistiller distiller) {
        this.distillers.put(ext.toLowerCase(), distiller);
    }
}

