/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.hibernate;

import java.util.HashMap;
import java.util.Map;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.type.NullableType;
import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.jdbc.JdbcUtils;
import org.asyrinx.joey.gen.model.rdb.Column;

public class HibernateUtils {
    private static final Map hibernateType2Name = HibernateUtils.newHibernateType2Name();

    public static NullableType getHibernateType(String sqlTypeName, int columnSize, int decimalDigits) {
        int sqlType = JdbcUtils.toJdbcType(sqlTypeName);
        return sqlType == 99999 ? null : HibernateUtils.getHibernateType(sqlType, columnSize, decimalDigits);
    }

    public static NullableType getHibernateType(int sqlType, int columnSize, int decimalDigits) {
        NullableType rv = Hibernate.SERIALIZABLE;
        if (sqlType == 1 || sqlType == 12) {
            rv = Hibernate.STRING;
        } else if (sqlType == -1) {
            rv = Hibernate.TEXT;
        } else if (sqlType == 2004) {
            rv = Hibernate.BLOB;
        } else if (sqlType == 2005) {
            rv = Hibernate.CLOB;
        } else if (sqlType == 6 || sqlType == 7) {
            rv = Hibernate.FLOAT;
        } else if (sqlType == 4) {
            rv = Hibernate.INTEGER;
        } else if (sqlType == 8) {
            rv = Hibernate.DOUBLE;
        } else if (sqlType == 91) {
            rv = Hibernate.DATE;
        } else if (sqlType == 93) {
            rv = Hibernate.TIMESTAMP;
        } else if (sqlType == 92) {
            rv = Hibernate.TIME;
        } else if (sqlType == 16) {
            rv = Hibernate.BOOLEAN;
        } else if (sqlType == 5) {
            rv = Hibernate.SHORT;
        } else if (sqlType == -7) {
            rv = Hibernate.BOOLEAN;
        } else if (sqlType == -5) {
            rv = Hibernate.LONG;
        } else if (sqlType == 2 || sqlType == 3) {
            rv = decimalDigits == 0 ? (columnSize == 1 ? Hibernate.BYTE : (columnSize < 5 ? Hibernate.SHORT : (columnSize < 10 ? Hibernate.INTEGER : Hibernate.LONG))) : (columnSize < 9 ? Hibernate.FLOAT : Hibernate.DOUBLE);
        }
        return rv;
    }

    public static NullableType getHibernateType(Column column) {
        return HibernateUtils.getHibernateType(column.getJdbcType(), column.getSizeAsInt(), column.getDeciamlSizeAsInt());
    }

    public static String toHibernateCascade(String cascade) {
        if (StringUtils.isEmpty((String)cascade)) {
            return "none";
        }
        if ("none".equals(cascade)) {
            return "none";
        }
        if ("all".equals(cascade)) {
            return "all";
        }
        if ("update".equals(cascade)) {
            return "save-update";
        }
        if ("delete".equals(cascade)) {
            return "delete";
        }
        return "none";
    }

    public static String getHibernateTypeName(Column column) {
        NullableType type = HibernateUtils.getHibernateType(column);
        return HibernateUtils.getHibernateTypeName(type);
    }

    public static String getHibernateTypeName(NullableType type) {
        return (String)hibernateType2Name.get(type);
    }

    private static Map newHibernateType2Name() {
        HashMap<NullableType, String> result = new HashMap<NullableType, String>();
        result.put(Hibernate.LONG, "LONG");
        result.put(Hibernate.SHORT, "SHORT");
        result.put(Hibernate.INTEGER, "INTEGER");
        result.put(Hibernate.BYTE, "BYTE");
        result.put(Hibernate.FLOAT, "FLOAT");
        result.put(Hibernate.DOUBLE, "DOUBLE");
        result.put(Hibernate.CHARACTER, "CHARACTER");
        result.put(Hibernate.STRING, "STRING");
        result.put(Hibernate.TIME, "TIME");
        result.put(Hibernate.DATE, "DATE");
        result.put(Hibernate.TIMESTAMP, "TIMESTAMP");
        result.put(Hibernate.BOOLEAN, "BOOLEAN");
        result.put(Hibernate.TRUE_FALSE, "TRUE_FALSE");
        result.put(Hibernate.YES_NO, "YES_NO");
        result.put(Hibernate.BIG_DECIMAL, "BIG_DECIMAL");
        result.put(Hibernate.BINARY, "BINARY");
        result.put(Hibernate.TEXT, "TEXT");
        result.put(Hibernate.BLOB, "BLOB");
        result.put(Hibernate.CLOB, "CLOB");
        result.put(Hibernate.CALENDAR, "CALENDAR");
        result.put(Hibernate.CALENDAR_DATE, "CALENDAR_DATE");
        result.put(Hibernate.LOCALE, "LOCALE");
        result.put(Hibernate.CURRENCY, "CURRENCY");
        result.put(Hibernate.TIMEZONE, "TIMEZONE");
        result.put(Hibernate.CLASS, "CLASS");
        result.put(Hibernate.SERIALIZABLE, "SERIALIZABLE");
        return result;
    }
}

