/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.asyrinx.brownie.core.lang.ClassUtils;
import org.asyrinx.joey.gen.model.ElementSet;

public abstract class Element
implements Cloneable {
    private Element parent = null;
    private String name = null;
    private String label = null;
    private String description = null;
    private Map options = null;
    private Element original = null;

    public Element() {
        this(null, null);
    }

    public Element(Element parent) {
        this(parent, null);
    }

    public Element(String name) {
        this(null, name);
    }

    public Element(Element parent, String name) {
        this(parent, name, null);
    }

    public Element(Element parent, String name, String label) {
        this.name = name;
        this.label = label;
        this.setParentElement(parent);
    }

    public String getElementType() {
        return ClassUtils.toShortClassName(this.getClass());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getFullName() {
        return this.getParentElement() == null ? this.getName() : String.valueOf(this.getParentElement().getFullName()) + "." + this.getName();
    }

    public Element getParentElement() {
        return this.parent;
    }

    protected void setParentElement(Element parent) {
        if (this.parent == parent) {
            return;
        }
        Element element = parent == null ? null : (this.parent = parent.isEntity() ? parent : parent.getParentElement());
        if (this.parent != null) {
            this.parent.add(this);
        }
    }

    public boolean isEntity() {
        return true;
    }

    public void add(Element element) {
        if (!(element instanceof ElementSet)) {
            throw new UnsupportedOperationException("element must not be ." + element.getClass().getName() + " @" + this.getClass().getName());
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map getOptions() {
        if (this.options == null) {
            this.options = new HashMap(1);
        }
        return this.options;
    }

    public void setOptions(Map options) {
        this.options = options != null ? options : Collections.EMPTY_MAP;
    }

    public Object getOption(String key) {
        Object option = this.getOptions().get(key);
        return option != null ? option : (this.getParentElement() == null ? null : this.getParentElement().getOption(key));
    }

    public Element getOriginal() {
        return this.original;
    }

    public void setOriginal(Element original) {
        this.original = original;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Element)) {
            return false;
        }
        Element other = (Element)obj;
        return new EqualsBuilder().append((Object)this.getName(), (Object)other.getName()).append((Object)this.getLabel(), (Object)other.getLabel()).append((Object)this.getOptions(), (Object)other.getOptions()).isEquals();
    }

    public int getAncestorDepth() {
        if (this.getParentElement() != null) {
            return this.getParentElement().getAncestorDepth() + 1;
        }
        return 0;
    }

    public String toString() {
        return this.getFullName();
    }
}

