/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model.command;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.LogFactory;
import org.asyrinx.brownie.core.log.DispatchLog;
import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.ElementVisitor;
import org.asyrinx.joey.gen.model.command.ValidationError;

public class Command
implements ElementVisitor {
    private boolean strict = true;
    protected final List errors = new ArrayList();
    protected final DispatchLog log = new DispatchLog(LogFactory.getLog(this.getClass()), "info");

    protected String element2String(Element element, String msg) {
        if (element != null) {
            msg = String.valueOf(msg) + " @" + element.getFullName();
        }
        msg = String.valueOf(msg) + " (by command '" + this.getClass().getName() + "')";
        return msg;
    }

    protected void addError(String msg) {
        this.addError(null, msg);
    }

    protected void addError(Element element, String msg) {
        this.addError(element, msg, this.isStrict());
    }

    protected void addError(Element element, String msg, boolean exit) {
        msg = this.element2String(element, msg);
        ValidationError error = new ValidationError(msg, element);
        if (exit) {
            throw error;
        }
        this.log.warn((Object)msg);
        this.errors.add(error);
    }

    protected void log(String msg) {
        this.log(null, msg);
    }

    protected void log(Element element, String msg) {
        msg = this.element2String(element, msg);
        this.log.log((Object)msg);
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void execute(Element element) {
        throw new UnsupportedOperationException("subclass must override");
    }

    public void visit(Element element) {
        throw new UnsupportedOperationException();
    }

    public List getErrors() {
        return this.errors;
    }
}

