/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.java.AppDomain;
import org.asyrinx.joey.gen.model.java.EntityKey;
import org.asyrinx.joey.gen.model.java.EntityKeySet;
import org.asyrinx.joey.gen.model.java.PackageType;
import org.asyrinx.joey.gen.model.java.Property;
import org.asyrinx.joey.gen.model.java.PropertySet;
import org.asyrinx.joey.gen.model.java.Reference;
import org.asyrinx.joey.gen.model.java.ReferenceEntry;
import org.asyrinx.joey.gen.model.java.ReferenceSet;
import org.asyrinx.joey.gen.model.java.Type;
import org.asyrinx.joey.gen.model.java.TypeCategory;

public class Entity
extends Element
implements Type {
    private final PropertySet properties = new PropertySet(this);
    private final EntityKeySet keys = new EntityKeySet(this);
    private final ReferenceSet references = new ReferenceSet(this);
    private final Set imports = new HashSet();
    private String packageTemplate = null;
    private final Map packageNames = new HashMap();
    private String superClassName = null;
    private Entity superClass = null;
    private final List assignableEntities = new ArrayList();
    private Property captionProperty = null;
    private String interfaces = null;

    public Entity() {
    }

    public Entity(AppDomain parent) {
        super(parent);
    }

    public Entity(String name) {
        super(name);
    }

    public Entity(AppDomain parent, String name) {
        super(parent, name);
    }

    public Entity(Element parent, String name, String label) {
        super(parent, name, label);
    }

    public AppDomain getParent() {
        return (AppDomain)super.getParentElement();
    }

    public String getFqn() {
        return String.valueOf(this.getPackage()) + "." + this.getName();
    }

    public String getPackage() {
        return this.getPackageName();
    }

    public boolean isPrimitive() {
        return false;
    }

    public Type toClass() {
        return this;
    }

    public Type toPrimitive() {
        return null;
    }

    public TypeCategory getCategory() {
        return TypeCategory.OTHERS;
    }

    public boolean isNumber() {
        return this.getCategory() == TypeCategory.NUMBER;
    }

    public void add(Element element) {
        if (element instanceof Property) {
            this.properties.add((Property)element);
        } else if (element instanceof Reference) {
            this.references.add((Reference)element);
        } else if (element instanceof EntityKey) {
            this.keys.add((EntityKey)element);
        } else {
            super.add(element);
        }
    }

    public String getPackageTemplate() {
        return this.packageTemplate;
    }

    public void setPackageTemplate(String packageTemplate) {
        this.packageTemplate = packageTemplate;
    }

    public String getPackageName() {
        return this.getPackage(PackageType.ENTITY.getName());
    }

    public void setPackageName(String packageName) {
        this.setPackage(PackageType.ENTITY.getName(), packageName);
    }

    public String getPackage(String packageType) {
        return (String)this.packageNames.get(packageType);
    }

    public void setPackage(String type, String value) {
        this.packageNames.put(type, value);
    }

    public PropertySet getProperties() {
        return this.properties;
    }

    public EntityKeySet getKeys() {
        return this.keys;
    }

    public ReferenceSet getReferences() {
        return this.references;
    }

    public EntityKey getPrimaryKey() {
        if (this.getSuperClass() != null) {
            return this.getSuperClass().getPrimaryKey();
        }
        return this.keys.getPrimaryKey();
    }

    public List getReferencesContainedAsLocal(Property property) {
        return this.getReferences().getReferencesContainedAsLocal(property);
    }

    public List getReferencesContainedAsForeign(Entity javaClass) {
        return this.getReferences().getReferencesContainedAsForeign(javaClass);
    }

    public List getReferencesContainedAsForeign(Property property) {
        return this.getParent().getReferencesContainedAsForeign(property);
    }

    public List getReferreds() {
        return this.getParent().getReferencesContainedAsForeign(this);
    }

    public Set getReferredEntities() {
        List referreds = this.getReferreds();
        HashSet<Entity> result = new HashSet<Entity>();
        Iterator i = referreds.iterator();
        while (i.hasNext()) {
            Reference reference = (Reference)i.next();
            result.add(reference.getParent());
        }
        return result;
    }

    public void findReferencesContainedAsForeign(Entity javaClass, List dest) {
        this.getReferences().findReferencesContainedAsForeign(javaClass, dest);
    }

    public void findReferencesContainedAsLocal(Entity javaClass, List dest) {
        this.getReferences().findReferencesContainedAsLocal(javaClass, dest);
        if (this.getSuperClass() != null) {
            this.getSuperClass().findReferencesContainedAsLocal(javaClass, dest);
        }
    }

    public Set getImports() {
        return this.imports;
    }

    public Entity getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(Entity superClass) {
        this.superClass = superClass;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public void setSuperClassName(String superClassName) {
        this.superClassName = superClassName;
    }

    public List getPropertiesExtended() {
        if (this.getSuperClass() == null) {
            return new ArrayList();
        }
        ArrayList result = new ArrayList(this.getSuperClass().getPropertiesExtended());
        result.addAll(this.getSuperClass().getProperties().toList());
        return result;
    }

    public List getPropertiesAll() {
        List result = this.getPropertiesExtended();
        result.addAll(this.getProperties().toList());
        return result;
    }

    public List getConstructorParams() {
        List<Property> result = this.getSuperClass() != null ? this.getSuperClass().getConstructorParams() : new ArrayList();
        HashSet<Property> used = new HashSet<Property>();
        Iterator i = this.getProperties().iterator();
        while (i.hasNext()) {
            Property property = (Property)i.next();
            this.addReferenceOfProperty(result, used, property);
            if (used.contains(property) || property.isExtended()) continue;
            result.add(property);
            used.add(property);
        }
        return result;
    }

    private void addReferenceOfProperty(List result, Set used, Property property) {
        Iterator i = property.getReferencesContainedAsLocal().iterator();
        while (i.hasNext()) {
            Reference reference = (Reference)i.next();
            if (used.contains(reference)) continue;
            result.add(reference);
            used.add(reference);
            this.addPropertyAsUsed(used, reference);
        }
    }

    private void addPropertyAsUsed(Set used, Reference reference) {
        Iterator iterator = reference.iterator();
        while (iterator.hasNext()) {
            ReferenceEntry entry = (ReferenceEntry)iterator.next();
            used.add(entry.getLocal());
        }
    }

    public List getSuperClasses() {
        ArrayList<Entity> result = this.getSuperClass() != null ? this.getSuperClass().getSuperClasses() : new ArrayList<Entity>();
        result.add(this);
        return result;
    }

    public List getPresentProperties() {
        return this.getConstructorParams();
    }

    public Set getReferenceEntities() {
        HashSet<Entity> result = new HashSet<Entity>();
        Iterator i = this.getReferences().iterator();
        while (i.hasNext()) {
            Reference reference = (Reference)i.next();
            result.add(reference.getReferenceClass());
        }
        return result;
    }

    public List getAssignableEntities() {
        return this.assignableEntities;
    }

    public Set getReferenceEntitiesAll() {
        HashSet result = new HashSet();
        Entity current = this;
        while (current != null) {
            result.addAll(current.getReferenceEntities());
            current = current.getSuperClass();
        }
        return result;
    }

    public List getReferencesAll() {
        ArrayList result = new ArrayList();
        Entity current = this;
        while (current != null) {
            result.addAll(current.getReferences().toList());
            current = current.getSuperClass();
        }
        return result;
    }

    public Property getCaptionProperty() {
        return this.captionProperty;
    }

    public void setCaptionProperty(Property captionProperty) {
        this.captionProperty = captionProperty;
    }

    public List getReferredAll() {
        ArrayList result = new ArrayList();
        Entity current = this;
        while (current != null) {
            result.addAll(current.getReferreds());
            current = current.getSuperClass();
        }
        return result;
    }

    public Set getReferredEntitiesAll() {
        HashSet result = new HashSet();
        Entity current = this;
        while (current != null) {
            result.addAll(current.getReferredEntities());
            current = current.getSuperClass();
        }
        return result;
    }

    public Set getRelatedEntities() {
        HashSet result = new HashSet();
        result.addAll(this.getReferenceEntities());
        result.addAll(this.getReferredEntities());
        return result;
    }

    public Set getRelatedEntitiesAll() {
        HashSet result = new HashSet();
        result.addAll(this.getReferenceEntitiesAll());
        result.addAll(this.getReferredEntitiesAll());
        return result;
    }

    public boolean isAssignable(Entity entity) {
        Entity current = this;
        while (current != null) {
            if (current == entity) {
                return true;
            }
            current = current.getSuperClass();
        }
        return false;
    }

    public String getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(String interfaces) {
        this.interfaces = interfaces;
    }
}

