/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.hibernate.Cascade;
import org.asyrinx.joey.gen.model.ElementSet;
import org.asyrinx.joey.gen.model.java.Entity;
import org.asyrinx.joey.gen.model.java.Parameter;
import org.asyrinx.joey.gen.model.java.Property;
import org.asyrinx.joey.gen.model.java.ReferenceEntry;
import org.asyrinx.joey.gen.model.java.ReferenceType;
import org.asyrinx.joey.gen.model.java.Type;

public class Reference
extends ElementSet
implements Parameter {
    private Entity referenceClass = null;
    private ReferenceType type = ReferenceType.NORMAL;
    private Cascade cascade = null;

    public Reference(Entity parent) {
        super(parent);
    }

    public Reference(Entity parent, String name) {
        super(parent, name);
    }

    public boolean isEntity() {
        return true;
    }

    public Entity getParent() {
        return (Entity)super.getParentElement();
    }

    public void add(ReferenceEntry entry) {
        super.add(entry);
    }

    public boolean contains(ReferenceEntry entry) {
        return super.contains(entry);
    }

    public ReferenceEntry getEntry(int index) {
        return (ReferenceEntry)super.getElement(index);
    }

    public ReferenceEntry getEntry(String name) {
        return (ReferenceEntry)super.getElement(name);
    }

    public ReferenceEntry removeEntry(String name) {
        return (ReferenceEntry)super.removeElement(name);
    }

    public String getReferenceClassName() {
        return this.getReferenceClass() == null ? null : this.getReferenceClass().getName();
    }

    public Entity getReferenceClass() {
        return this.referenceClass;
    }

    public void setReferenceClass(Entity referenceClass) {
        this.referenceClass = referenceClass;
    }

    public boolean containsAsLocal(Property property) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            ReferenceEntry entry = (ReferenceEntry)i.next();
            if (entry.getLocal() != property) continue;
            return true;
        }
        return false;
    }

    public boolean containsAsForeign(Property property) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            ReferenceEntry entry = (ReferenceEntry)i.next();
            if (entry.getForeign() != property) continue;
            return true;
        }
        return false;
    }

    public String getPropertyNameInReferred(boolean plural) {
        String className = this.getParent().getName();
        String relatedByCol = "";
        Set otherRefs = this.getParent().getParent().findReferences(this.getParent(), this.getReferenceClass());
        if (otherRefs.size() > 1) {
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ReferenceEntry entry = (ReferenceEntry)i.next();
                if (entry.getLocal().getReferencesContainedAsLocal().isEmpty()) continue;
                relatedByCol = String.valueOf(relatedByCol) + entry.getLocal().getCapitalizedName();
            }
        }
        if (StringUtils.isEmpty((String)relatedByCol)) {
            return plural ? StringUtils.uncapitalize((String)(String.valueOf(className) + "s")) : StringUtils.uncapitalize((String)className);
        }
        String s = String.valueOf(plural ? "s" : "") + "RelatedBy";
        return String.valueOf(StringUtils.uncapitalize((String)className)) + s + relatedByCol;
    }

    public String getPropertyNameInReferred() {
        return this.getPropertyNameInReferred(true);
    }

    public String getPropertyNameInLocal() {
        Entity foreignClass = this.getReferenceClass();
        String className = foreignClass.getName();
        String relCol = "";
        ArrayList otherRefs = new ArrayList();
        Entity current = this.getParent();
        while (current != null) {
            otherRefs.addAll(current.getReferencesContainedAsForeign(foreignClass));
            current = current.getSuperClass();
        }
        if (otherRefs.size() > 1) {
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ReferenceEntry entry = (ReferenceEntry)i.next();
                if (entry.getLocal().getReferencesContainedAsLocal().isEmpty() && this.getReferenceClass() != this.getParent()) continue;
                relCol = String.valueOf(relCol) + entry.getLocal().getCapitalizedName();
            }
        }
        if (StringUtils.isNotEmpty((String)relCol)) {
            relCol = "RelatedBy" + relCol;
        }
        return StringUtils.uncapitalize((String)(String.valueOf(className) + relCol));
    }

    public ReferenceType getType() {
        return this.type;
    }

    public void setType(ReferenceType type) {
        this.type = type;
    }

    public boolean isForward() {
        return this.getType() != ReferenceType.EXTENDS;
    }

    public boolean isBackward() {
        return this.getType() == ReferenceType.BIDIRECTION;
    }

    public String getParamName() {
        return this.getPropertyNameInLocal();
    }

    public Type getParamType() {
        return this.getReferenceClass();
    }

    public Cascade getCascade() {
        return this.cascade;
    }

    public void setCascade(Cascade cascade) {
        this.cascade = cascade;
    }

    public String getCaption() {
        StringBuffer result = new StringBuffer();
        result.append(this.getParent().getName());
        result.append("-->");
        result.append(this.getReferenceClass().getName());
        result.append("[");
        Iterator i = this.iterator();
        while (i.hasNext()) {
            ReferenceEntry entry = (ReferenceEntry)i.next();
            result.append(entry.getLocal().getName());
            result.append("-->");
            result.append(entry.getForeign().getName());
            if (!i.hasNext()) continue;
            result.append(" ");
        }
        result.append("]");
        return result.toString();
    }

    public String toString() {
        return this.getCaption();
    }
}

