/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model.java.classes;

import java.util.HashMap;
import java.util.Map;
import org.asyrinx.joey.gen.model.java.Type;
import org.asyrinx.joey.gen.model.java.TypeCategory;

public abstract class EmbeddedClass
implements Type {
    private static final Map nameToType = new HashMap();
    private final String packageName;
    private final String className;
    private final TypeCategory category;

    public static EmbeddedClass get(String name) {
        return (EmbeddedClass)nameToType.get(name);
    }

    public EmbeddedClass(String packageName, String className, TypeCategory category) {
        this.packageName = packageName;
        this.className = className;
        this.category = category;
        nameToType.put(className, this);
    }

    public TypeCategory getCategory() {
        return this.category;
    }

    public String getFqn() {
        return String.valueOf(this.getPackage()) + "." + this.getName();
    }

    public String getPackage() {
        return this.getPackageName();
    }

    public String getName() {
        return this.className;
    }

    public boolean isPrimitive() {
        return false;
    }

    public Type toClass() {
        return this;
    }

    public Type toPrimitive() {
        return null;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean isNumber() {
        return this.getCategory() == TypeCategory.NUMBER;
    }
}

