/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model.java.classes;

import java.util.HashMap;
import java.util.Map;
import org.asyrinx.joey.gen.model.EnumerationEntry;
import org.asyrinx.joey.gen.model.java.JavaEnumeration;
import org.asyrinx.joey.gen.model.java.classes.PrimitiveType;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;

public class JoeyRuntimeClass {
    private static final Map rdbEnums = new HashMap();
    private static final Map javaEnums = new HashMap();
    public static final RdbEnumeration RDB_BOOLEAN_ENUM = JoeyRuntimeClass.createRdbBooleanEnum();
    public static final JavaEnumeration JAVA_BOOLEAN_ENUM = JoeyRuntimeClass.createJavaBooleanEnum();

    private static RdbEnumeration createRdbBooleanEnum() {
        RdbEnumeration result = new RdbEnumeration();
        result.setName("BooleanEnum");
        result.setValueType("INTEGER");
        result.setLabel("BOOLEAN");
        new EnumerationEntry(result, "0", "false", "false");
        new EnumerationEntry(result, "1", "true", "true");
        String key = result.getName();
        rdbEnums.put(key, result);
        return result;
    }

    private static JavaEnumeration createJavaBooleanEnum() {
        JavaEnumeration result = new JavaEnumeration();
        result.setName("BooleanEnum");
        result.setPackageName("org.asyrinx.brownie.core.lang.enum.util");
        result.setValueType("int");
        result.setValueTypeObj(PrimitiveType.INT);
        result.setLabel("BOOLEAN");
        result.setOriginal(RDB_BOOLEAN_ENUM);
        new EnumerationEntry(result, "0", "false", "false");
        new EnumerationEntry(result, "1", "true", "true");
        javaEnums.put(result.getName(), result);
        return result;
    }

    public static RdbEnumeration getRdbEnum(String enumName) {
        return (RdbEnumeration)rdbEnums.get(enumName);
    }

    public static JavaEnumeration getJavaEnum(String enumName) {
        return (JavaEnumeration)javaEnums.get(enumName);
    }
}

