/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model.pattern;

import org.asyrinx.joey.gen.model.command.ValidationError;
import org.asyrinx.joey.gen.model.pattern.Pattern;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Table;
import org.asyrinx.joey.gen.model.rdb.TablePattern;
import org.asyrinx.joey.gen.model.rdb.TablePatternParam;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SingleColumnPattern
implements Pattern {
    final String defaultColumnName;
    final String columnType;
    final String enum;
    final String label;

    public SingleColumnPattern(String defaultColumnName, String columnType, String label) {
        this(defaultColumnName, columnType, null, label);
    }

    public SingleColumnPattern(String defaultColumnName, String columnType, String string, String label) {
        this.defaultColumnName = defaultColumnName;
        this.columnType = columnType;
        this.enum = string;
        this.label = label;
    }

    public void expand(TablePattern tablePattern) {
        TablePatternParam param;
        if (tablePattern.isEmpty()) {
            param = new TablePatternParam(tablePattern, "columnName", null);
            param.setValue(this.defaultColumnName);
        } else {
            param = tablePattern.getParam("columnName");
            if (param == null) {
                throw new ValidationError("param named 'columnName' was not found", tablePattern);
            }
        }
        String columnName = param.getValue();
        Table table = tablePattern.getParent();
        Column column = new Column(table, columnName, this.columnType);
        column.setLabel(this.label);
        column.setRequired(true);
        column.setEnum(this.enum);
    }

    public boolean isTarget(String templatePath) {
        return "om/service".equals(templatePath);
    }
}

