/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model.rdb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.asyrinx.brownie.core.lang.NumberUtils;
import org.asyrinx.joey.gen.jdbc.JdbcUtils;
import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyType;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;
import org.asyrinx.joey.gen.model.rdb.Table;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Column
extends Element {
    private String type = null;
    private String size = null;
    private String decimalSize = null;
    private boolean required = false;
    private boolean primaryKey = false;
    private String defaultValue = null;
    private String enum = null;
    private boolean autoIncrement = false;
    private String idMethod = null;
    private String fk = null;
    private String fkType = ForeignKeyType.NORMAL.getName();
    private String fkCascade = "none";
    private boolean indexed = false;
    private boolean unique = false;
    private boolean extended = false;
    private boolean caption = false;

    public Column() {
        this(null, null, null);
    }

    public Column(Table parent, String name, String type) {
        super(parent, name);
        this.type = type;
    }

    public Column(Table parent, String name, String type, String size) {
        this(parent, name, type, size, false, false);
    }

    public Column(Table parent, String name, String type, String size, boolean required) {
        this(parent, name, type, size, required, false, null);
    }

    public Column(Table parent, String name, String type, String size, boolean required, boolean primaryKey) {
        this(parent, name, type, size, required, primaryKey, null);
    }

    public Column(Table parent, String name, String type, String size, boolean required, boolean primaryKey, String defaultValue) {
        super(parent, name);
        this.type = type;
        this.size = size;
        this.required = required;
        this.primaryKey = primaryKey;
        this.defaultValue = defaultValue;
    }

    public Table getParent() {
        return (Table)super.getParentElement();
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Column)) {
            return false;
        }
        Column other = (Column)obj;
        return new EqualsBuilder().append((Object)this.getType(), (Object)other.getType()).append((Object)this.getSize(), (Object)other.getSize()).append(this.isRequired(), other.isRequired()).append(this.isPrimaryKey(), other.isPrimaryKey()).append((Object)this.getDefaultValue(), (Object)other.getDefaultValue()).append((Object)this.getEnum(), (Object)other.getEnum()).isEquals();
    }

    public String getDefault() {
        return this.getDefaultValue();
    }

    public int getSizeAsInt() {
        return NumberUtils.toInt((Object)this.getSize(), (int)0);
    }

    public int getDeciamlSizeAsInt() {
        return NumberUtils.toInt((Object)this.getDecimalSize(), (int)0);
    }

    public void setDefault(String defaultValue) {
        this.setDefaultValue(defaultValue);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getJdbcType() {
        return JdbcUtils.toJdbcType(this.getType());
    }

    public String getEnum() {
        return this.enum;
    }

    public void setEnum(String string) {
        this.enum = string;
    }

    public RdbEnumeration getEnumeration() {
        Table table = this.getParent();
        if (table == null) {
            return null;
        }
        Database database = table.getParent();
        return database.getEnumerations().getEnumeration(this.getEnum());
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public String getIdMethod() {
        return this.idMethod;
    }

    public void setIdMethod(String idMethod) {
        this.idMethod = idMethod;
    }

    public String getFk() {
        return this.fk;
    }

    public void setFk(String fk) {
        this.fk = fk;
    }

    public String getFkCascade() {
        return this.fkCascade;
    }

    public void setFkCascade(String fkcascade) {
        this.fkCascade = fkcascade;
    }

    public String getFkType() {
        return this.fkType;
    }

    public void setFkType(String fkType) {
        this.fkType = fkType;
    }

    public void setFkb(String fkb) {
        throw new UnsupportedOperationException();
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public void setIndexed(boolean indexed) {
        this.indexed = indexed;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public void setExtended(boolean extended) {
        this.extended = extended;
    }

    public List getForeignKeysContainsAsLocal() {
        ArrayList<ForeignKey> result = new ArrayList<ForeignKey>();
        Table table = this.getParent();
        if (table == null) {
            return result;
        }
        Iterator i = table.getForeignKeys().iterator();
        while (i.hasNext()) {
            ForeignKey fk = (ForeignKey)i.next();
            if (!fk.containsAsLocal(this)) continue;
            result.add(fk);
        }
        return result;
    }

    public String getDecimalSize() {
        return this.decimalSize;
    }

    public void setDecimalSize(String decimalSize) {
        this.decimalSize = decimalSize;
    }

    public boolean isCaption() {
        return this.caption;
    }

    public void setCaption(boolean caption) {
        this.caption = caption;
    }
}

