/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model.rdb;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.joey.gen.model.ElementSet;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyType;
import org.asyrinx.joey.gen.model.rdb.Index;
import org.asyrinx.joey.gen.model.rdb.Table;

public class ForeignKey
extends ElementSet {
    private String foreign = null;
    private boolean indexed = true;
    private Index index = null;
    private ForeignKeyType type = ForeignKeyType.NORMAL;
    private String cascade = null;

    public ForeignKey() {
        this(null, null, null);
    }

    public ForeignKey(String foreignTable) {
        this(null, null, foreignTable);
    }

    public ForeignKey(String name, String foreignTable) {
        this(null, name, foreignTable);
    }

    public ForeignKey(Table parent, String foreignTable) {
        this(parent, null, foreignTable);
    }

    public ForeignKey(Table parent, String name, String foreignTable) {
        super(parent, name);
        this.foreign = foreignTable;
    }

    public boolean isEntity() {
        return true;
    }

    public void add(ForeignKeyEntry entry) {
        super.add(entry);
    }

    public boolean contains(ForeignKeyEntry entry) {
        return super.contains(entry);
    }

    public ForeignKeyEntry getEntry(int idx) {
        return (ForeignKeyEntry)super.getElement(idx);
    }

    public ForeignKeyEntry getEntry(String name) {
        return (ForeignKeyEntry)super.getElement(name);
    }

    public ForeignKeyEntry removeEntry(String name) {
        return (ForeignKeyEntry)super.removeElement(name);
    }

    public Table getParent() {
        return (Table)super.getParentElement();
    }

    public Table getLocal() {
        return this.getParent();
    }

    protected final Table getTable(String name) {
        Table parent = this.getParent();
        if (parent == null) {
            return null;
        }
        Database database = parent.getParent();
        if (database == null) {
            return null;
        }
        return database.getTables().getTable(name);
    }

    public Table getForeignTable() {
        return this.getTable(this.getForeign());
    }

    public String getLocalColumnNames() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            ForeignKeyEntry entry = (ForeignKeyEntry)i.next();
            list.add(entry.getLocalColumn().getName());
        }
        return StringUtils.join(list.iterator(), (String)",");
    }

    public String getForeignColumnNames() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            ForeignKeyEntry entry = (ForeignKeyEntry)i.next();
            list.add(entry.getForeignColumn().getName());
        }
        return StringUtils.join(list.iterator(), (String)",");
    }

    public String getForeign() {
        return this.foreign;
    }

    public void setForeign(String foreignTabe) {
        this.foreign = foreignTabe;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public void setIndexed(boolean indexed) {
        this.indexed = indexed;
    }

    public Index getIndex() {
        return this.index;
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    public ForeignKeyType getType() {
        return this.type;
    }

    public void setType(ForeignKeyType type) {
        this.type = type;
    }

    public boolean containsAsLocal(Column column) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            ForeignKeyEntry entry = (ForeignKeyEntry)i.next();
            if (entry.getLocalColumn() != column) continue;
            return true;
        }
        return false;
    }

    public String getCascade() {
        return this.cascade;
    }

    public void setCascade(String cascade) {
        this.cascade = cascade;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ForeignKey)) {
            return false;
        }
        ForeignKey other = (ForeignKey)obj;
        return new EqualsBuilder().append((Object)this.getForeign(), (Object)other.getForeign()).append((Object)this.getType(), (Object)other.getType()).append((Object)this.getCascade(), (Object)other.getCascade()).isEquals();
    }

    public boolean careChildOrder() {
        return true;
    }
}

