/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model.rdb.visitor;

import java.util.Iterator;
import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.EnumerationEntry;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;
import org.asyrinx.joey.gen.model.rdb.Index;
import org.asyrinx.joey.gen.model.rdb.IndexEntry;
import org.asyrinx.joey.gen.model.rdb.PrimaryKey;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;
import org.asyrinx.joey.gen.model.rdb.RdbVisitor;
import org.asyrinx.joey.gen.model.rdb.Table;
import org.asyrinx.joey.gen.model.rdb.TablePattern;
import org.asyrinx.joey.gen.model.rdb.TablePatternParam;
import org.asyrinx.joey.gen.model.rdb.Unique;
import org.asyrinx.joey.gen.model.rdb.visitor.RdbVisitorWrapper;

public class RdbTopDownVisitor
extends RdbVisitorWrapper {
    public RdbTopDownVisitor(RdbVisitor rdbVisitor) {
        super(rdbVisitor);
    }

    public void visit(Column column) {
        super.visit(column);
    }

    public void visit(Database database) {
        Element element;
        super.visit(database);
        Iterator iter = database.getEnumerations().iterator();
        while (iter.hasNext()) {
            element = (RdbEnumeration)iter.next();
            this.visit((RdbEnumeration)element);
        }
        iter = database.getTables().iterator();
        while (iter.hasNext()) {
            element = (Table)iter.next();
            this.visit((Table)element);
        }
    }

    public void visit(Databases databases) {
        super.visit(databases);
        Iterator iter = databases.getDatabases().iterator();
        while (iter.hasNext()) {
            Database element = (Database)iter.next();
            this.visit(element);
        }
    }

    public void visit(RdbEnumeration enumeration) {
        super.visit(enumeration);
        Iterator iter = enumeration.iterator();
        while (iter.hasNext()) {
            EnumerationEntry element = (EnumerationEntry)iter.next();
            this.visit(element);
        }
    }

    public void visit(EnumerationEntry enumerationEntry) {
        super.visit(enumerationEntry);
    }

    public void visit(ForeignKey foreignKey) {
        super.visit(foreignKey);
        Iterator iter = foreignKey.iterator();
        while (iter.hasNext()) {
            ForeignKeyEntry element = (ForeignKeyEntry)iter.next();
            this.visit(element);
        }
    }

    public void visit(ForeignKeyEntry foreignKeyEntry) {
        super.visit(foreignKeyEntry);
    }

    public void visit(Index index) {
        super.visit(index);
        Iterator iter = index.iterator();
        while (iter.hasNext()) {
            IndexEntry element = (IndexEntry)iter.next();
            this.visit(element);
        }
    }

    public void visit(IndexEntry indexEntry) {
        super.visit(indexEntry);
    }

    public void visit(PrimaryKey primaryKey) {
        super.visit(primaryKey);
    }

    public void visit(Table table) {
        Element element;
        super.visit(table);
        Iterator iter = table.getColumns().iterator();
        while (iter.hasNext()) {
            element = (Column)iter.next();
            this.visit((Column)element);
        }
        this.visit(table.getPrimaryKey());
        iter = table.getIndexes().iterator();
        while (iter.hasNext()) {
            element = (Index)iter.next();
            this.visit((Index)element);
        }
        iter = table.getUniques().iterator();
        while (iter.hasNext()) {
            element = (Unique)iter.next();
            this.visit((Unique)element);
        }
        iter = table.getForeignKeys().iterator();
        while (iter.hasNext()) {
            element = (ForeignKey)iter.next();
            this.visit((ForeignKey)element);
        }
        Iterator i = table.getPatterns().iterator();
        while (i.hasNext()) {
            TablePattern pattern = (TablePattern)i.next();
            this.visit(pattern);
        }
    }

    public void visit(TablePattern tablePattern) {
        super.visit(tablePattern);
        Iterator i = tablePattern.iterator();
        while (i.hasNext()) {
            TablePatternParam param = (TablePatternParam)i.next();
            this.visit(param);
        }
    }

    public void visit(Unique unique) {
        super.visit(unique);
        Iterator iter = unique.iterator();
        while (iter.hasNext()) {
            IndexEntry element = (IndexEntry)iter.next();
            this.visit(element);
        }
    }
}

