/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.tapestry.page.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.html.BasePage;
import org.asyrinx.brownie.core.query.exp.IExpression;
import org.asyrinx.brownie.tapestry.page.ReloadablePage;
import org.asyrinx.joey.entity.service.EntityServiceDispatcher;
import org.asyrinx.joey.tapestry.page.CaptionablePage;

public abstract class BaseListPage
extends BasePage
implements CaptionablePage,
ReloadablePage {
    private List targets = null;
    private IExpression condition = null;
    private boolean searchClicked = false;
    private boolean deleteDuplicates = true;

    public abstract String getPageCaption();

    public abstract EntityServiceDispatcher getEntityServiceDispatcher();

    public abstract Class getTargetClass();

    public List getTargets() {
        return this.targets;
    }

    public void setTargets(List targets) {
        this.targets = targets;
    }

    public IExpression getCondition() {
        return this.condition;
    }

    public void setCondition(IExpression condition) {
        this.condition = condition;
    }

    public void clickSearch(IRequestCycle cycle) {
        this.loadTargets();
        this.searchClicked = true;
    }

    public void loadTargets() {
        List results = this.getEntityServiceDispatcher().select(this.getTargetClass(), this.getCondition());
        this.setTargets(results);
        if (this.isDeleteDuplicates()) {
            this.doDeleteDuplicates();
        }
    }

    private void doDeleteDuplicates() {
        ArrayList result = new ArrayList();
        Iterator i = this.getTargets().iterator();
        while (i.hasNext()) {
            Object object = i.next();
            if (result.contains(object)) continue;
            result.add(object);
        }
        this.setTargets(result);
    }

    public void renderPage(IMarkupWriter writer, IRequestCycle cycle) {
        if (!this.searchClicked) {
            this.loadTargets();
        }
        super.renderPage(writer, cycle);
        this.searchClicked = false;
    }

    public void reload() {
        this.loadTargets();
    }

    public boolean isDeleteDuplicates() {
        return this.deleteDuplicates;
    }

    public void setDeleteDuplicates(boolean deleteDuplicates) {
        this.deleteDuplicates = deleteDuplicates;
    }
}

