/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.lang;

import java.lang.reflect.InvocationTargetException;
import org.asyrinx.brownie.core.lang.NumberUtils;
import org.asyrinx.brownie.core.lang.UnsupportedClassRuntimeException;

public class PropertyUtils
extends org.apache.commons.beanutils.PropertyUtils {
    public static String getPropertyAsString(Object object, String propName) {
        return PropertyUtils.getPropertyAsString(object, propName, null);
    }

    public static String getPropertyAsString(Object object, String propName, String defaultValue) {
        try {
            return String.valueOf(org.apache.commons.beanutils.PropertyUtils.getProperty((Object)object, (String)propName));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int getPropertyAsInt(Object object, String propName) {
        return PropertyUtils.getPropertyAsInt(object, propName, 0);
    }

    public static int getPropertyAsInt(Object object, String propName, int defaultValue) {
        Object result;
        try {
            result = org.apache.commons.beanutils.PropertyUtils.getProperty((Object)object, (String)propName);
        }
        catch (Exception e) {
            return defaultValue;
        }
        if (result instanceof Number) {
            return ((Number)result).intValue();
        }
        if (result instanceof String) {
            return NumberUtils.toInt(result, 0);
        }
        return defaultValue;
    }

    public static long getPropertyAsLong(Object object, String propName) {
        return PropertyUtils.getPropertyAsLong(object, propName, 0L);
    }

    public static long getPropertyAsLong(Object object, String propName, long defaultValue) {
        Object result;
        try {
            result = org.apache.commons.beanutils.PropertyUtils.getProperty((Object)object, (String)propName);
        }
        catch (Exception e) {
            return defaultValue;
        }
        if (result instanceof Number) {
            return ((Number)result).longValue();
        }
        if (result instanceof String) {
            return NumberUtils.toLong(result, 0L);
        }
        return defaultValue;
    }

    public static boolean getPropertyAsBoolean(Object object, String propName) {
        return PropertyUtils.getPropertyAsBoolean(object, propName, false);
    }

    public static boolean getPropertyAsBoolean(Object object, String propName, boolean defaultValue) {
        Object result;
        try {
            result = org.apache.commons.beanutils.PropertyUtils.getProperty((Object)object, (String)propName);
        }
        catch (Exception e) {
            return defaultValue;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result instanceof String) {
            return "true".equalsIgnoreCase((String)result);
        }
        return defaultValue;
    }

    public static Object getProperty(Object target, String property, Class baseClass) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object result = org.apache.commons.beanutils.PropertyUtils.getProperty((Object)target, (String)property);
        if (result == null) {
            return null;
        }
        if (baseClass != null && !baseClass.isInstance(result)) {
            throw new UnsupportedClassRuntimeException("property '" + property + "' of object '" + target + "' is not instanceof '" + target.getClass().getName() + "'. ");
        }
        return result;
    }

    public static Object requireProperty(Object target, String property, Class baseClass) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object result = org.apache.commons.beanutils.PropertyUtils.getProperty((Object)target, (String)property);
        if (result == null) {
            throw new UnsupportedClassRuntimeException("no object for property '" + property + "' of object '" + target);
        }
        if (baseClass != null && !baseClass.isInstance(result)) {
            throw new UnsupportedClassRuntimeException("property '" + property + "' of object '" + target + "' is not instanceof '" + target.getClass().getName() + "'. ");
        }
        return result;
    }
}

