/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.query;

import java.text.DecimalFormat;
import java.util.Date;
import java.util.Iterator;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.core.lang.UnsupportedClassRuntimeException;
import org.asyrinx.brownie.core.query.Select;
import org.asyrinx.brownie.core.query.SelectBuilder;
import org.asyrinx.brownie.core.query.StatementType;
import org.asyrinx.brownie.core.query.exp.ICompositeExpression;
import org.asyrinx.brownie.core.query.exp.IExpression;
import org.asyrinx.brownie.core.query.exp.IExpressionWrap;
import org.asyrinx.brownie.core.query.exp.IFieldCompare;
import org.asyrinx.brownie.core.query.exp.IFieldValuedExpression;
import org.asyrinx.brownie.core.query.model.Field;
import org.asyrinx.brownie.core.query.model.FieldAlias;
import org.asyrinx.brownie.core.query.model.FieldAliasList;
import org.asyrinx.brownie.core.query.model.Table;
import org.asyrinx.brownie.core.query.model.TableAlias;
import org.asyrinx.brownie.core.query.model.TableAliasList;
import org.asyrinx.brownie.core.util.jp.JpDateFormat;

public class BasicSelectBuilder
implements SelectBuilder {
    private final StatementType statementType;
    private boolean needTableAliasName = false;
    private final CompositeBracket compositeBracket = new CompositeBracket();
    private char stringQuote = (char)39;
    private String bracketBegin = "(";
    private String bracketEnd = ")";
    private String defaultDateFormat = "yyyy-MM-dd HH:mm:ss";
    private String defaultNumberFormat = "yyyy-MM-dd HH:mm:ss";
    private boolean ignoreRootBracket = true;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public BasicSelectBuilder() {
        this(StatementType.SQL);
    }

    public BasicSelectBuilder(StatementType statementType) {
        this.statementType = statementType;
    }

    public String getFieldName(Field field) {
        return this.statementType.getFieldName(field);
    }

    public String getTableName(Table table) {
        return this.statementType.getTableName(table);
    }

    public String buildSelect(Select select) {
        this.needTableAliasName = !this.hasSinlgleTableAlias(select);
        StringBuffer result = new StringBuffer();
        this.doBuildSelect(select, result);
        return result.toString();
    }

    public String buildExpression(IExpression expression) {
        this.needTableAliasName = false;
        return this.buildExpressionImpl(expression);
    }

    public String buildExpressionImpl(IExpression expression) {
        StringBuffer result = new StringBuffer();
        this.doBuildExpression(expression, result);
        return result.toString();
    }

    protected void doBuildSelect(Select select, StringBuffer dest) {
        this.addWhenNotEmpty("select", dest, this.doBuildFieldAliasList(select.getFields()));
        this.addWhenNotEmpty("from", dest, this.doBuildTableAliasList(select.getFroms()));
        this.addWhenNotEmpty("where", dest, this.doBuildExpression(select.getWhere()));
        this.addWhenNotEmpty("group by", dest, this.doBuildFieldAliasList(select.getGroupBys()));
        this.addWhenNotEmpty("having", dest, this.doBuildExpression(select.getHavings()));
        this.addWhenNotEmpty("order by", dest, this.doBuildFieldAliasList(select.getOrderBys()));
    }

    protected void addWhenNotEmpty(String header, StringBuffer dest, StringBuffer source) {
        if (source.length() == 0) {
            return;
        }
        if (dest.length() != 0) {
            dest.append(" ");
        }
        dest.append(header);
        dest.append(" ");
        dest.append(source);
    }

    protected StringBuffer doBuildFieldAliasList(FieldAliasList aliasList) {
        StringBuffer result = new StringBuffer();
        Iterator i = aliasList.iterator();
        while (i.hasNext()) {
            FieldAlias alias = (FieldAlias)i.next();
            result.append(alias.getOwner().getName());
            result.append(".");
            result.append(this.getFieldName(alias.getField()));
            result.append(" as ");
            result.append(alias.getName());
            if (!i.hasNext()) continue;
            result.append(", ");
        }
        return result;
    }

    protected StringBuffer doBuildTableAliasList(TableAliasList aliasList) {
        StringBuffer result = new StringBuffer();
        Iterator i = aliasList.iterator();
        while (i.hasNext()) {
            TableAlias alias = (TableAlias)i.next();
            result.append(this.getTableName(alias.getOriginal()));
            if (this.needTableAliasName) {
                result.append(" as ");
                result.append(alias.getName());
            }
            if (!i.hasNext()) continue;
            result.append(", ");
        }
        return result;
    }

    private boolean hasSinlgleTableAlias(Select select) {
        if (select.getFroms().isEmpty()) {
            return true;
        }
        if (select.getFroms().size() > 1) {
            return false;
        }
        TableAlias tableAlias = select.getFroms().get(0);
        return StringUtils.equals((String)tableAlias.getName(), (String)this.getTableName(tableAlias.getOriginal()));
    }

    protected StringBuffer doBuildExpression(IExpression expression) {
        this.compositeBracket.reset();
        StringBuffer result = new StringBuffer();
        this.doBuildExpression(expression, result);
        return result;
    }

    protected void doBuildExpression(IExpression expression, StringBuffer dest) {
        if (expression == null) {
            return;
        }
        if (expression instanceof ICompositeExpression) {
            this.doBuildComposite((ICompositeExpression)expression, dest);
        } else if (expression instanceof IExpressionWrap) {
            this.doBuildWrap((IExpressionWrap)expression, dest);
        } else if (expression instanceof IFieldValuedExpression) {
            this.doBuildFieldExpression((IFieldValuedExpression)expression, dest);
        } else if (expression instanceof IFieldCompare) {
            this.doBuildFieldCompare((IFieldCompare)expression, dest);
        } else {
            throw new UnsupportedClassRuntimeException(expression.getClass().getName());
        }
    }

    protected void doBuildComposite(ICompositeExpression composite, StringBuffer dest) {
        StringBuffer result = new StringBuffer();
        if (composite.size() > 1) {
            this.compositeBracket.increment();
        }
        boolean useBracket = this.compositeBracket.needBracket();
        Iterator i = composite.iterator();
        while (i.hasNext()) {
            IExpression exp = (IExpression)i.next();
            this.doBuildExpression(exp, result);
            if (!i.hasNext()) continue;
            if (useBracket) {
                result.append(this.getBracketEnd());
                result.append(" ");
                result.append(composite.getOperator());
                result.append(" ");
                result.append(this.getBracketBegin());
                continue;
            }
            result.append(" ");
            result.append(composite.getOperator());
            result.append(" ");
        }
        if (result.length() > 1) {
            if (useBracket) {
                dest.append(this.getBracketBegin());
                dest.append(result.toString());
                dest.append(this.getBracketEnd());
            } else {
                dest.append(result.toString());
            }
        }
    }

    protected void doBuildWrap(IExpressionWrap wrap, StringBuffer dest) {
        if (StringUtils.isEmpty((String)wrap.getOperator())) {
            this.doBuildExpression(wrap.getContent(), dest);
        } else {
            this.compositeBracket.increment();
            dest.append(wrap.getOperator());
            dest.append(" ");
            dest.append(this.getBracketBegin());
            this.doBuildExpression(wrap.getContent(), dest);
            dest.append(this.getBracketEnd());
        }
    }

    protected void appendExpressionFieldName(FieldAlias field, StringBuffer dest) {
        if (this.needTableAliasName) {
            dest.append(field.getOwner().getName());
            dest.append(".");
        }
        dest.append(this.getFieldName(field.getField()));
    }

    protected void doBuildFieldExpression(IFieldValuedExpression fieldExpression, StringBuffer dest) {
        FieldAlias field = fieldExpression.getField();
        this.appendExpressionFieldName(field, dest);
        dest.append(" ");
        dest.append(fieldExpression.getOperator());
        dest.append(" ");
        dest.append(this.dispatch4Value(field, fieldExpression.getValue()));
    }

    protected void doBuildFieldCompare(IFieldCompare compare, StringBuffer dest) {
        this.appendExpressionFieldName(compare.getLeft(), dest);
        dest.append(" ");
        dest.append(compare.getOperator());
        dest.append(" ");
        this.appendExpressionFieldName(compare.getRight(), dest);
    }

    protected String dispatch4Value(FieldAlias field, Object value) {
        Class clazz = field.getType();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return this.toStringValue(value);
        }
        Class clazz3 = field.getType();
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.isAssignableFrom(clazz4)) {
            String format = StringUtils.isEmpty((String)field.getFormat()) ? this.getDefaultDateFormat() : field.getFormat();
            return this.toStringValue(this.toDateValue(format, value));
        }
        Class clazz5 = field.getType();
        Class<?> clazz6 = class$2;
        if (clazz6 == null) {
            try {
                clazz6 = class$2 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz5.isAssignableFrom(clazz6)) {
            String format = StringUtils.isEmpty((String)field.getFormat()) ? this.getDefaultNumberFormat() : field.getFormat();
            return this.toNumberValue(field.getType(), format, value);
        }
        return String.valueOf(value);
    }

    protected String toDateValue(String format, Object value) {
        if (value instanceof Date) {
            JpDateFormat dateFormat = new JpDateFormat(format);
            return dateFormat.format((Date)value);
        }
        return value.toString();
    }

    protected String toNumberValue(Class type, String format, Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            if (!StringUtils.isEmpty((String)format)) {
                DecimalFormat numberFormat = new DecimalFormat(format);
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type.isAssignableFrom(clazz)) {
                    return numberFormat.format(number.doubleValue());
                }
                return numberFormat.format(number.longValue());
            }
        }
        return value.toString();
    }

    protected String toStringValue(Object value) {
        return StringUtils.toQuoted(String.valueOf(value), this.getStringQuote());
    }

    public char getStringQuote() {
        return this.stringQuote;
    }

    public void setStringQuote(char stringQuote) {
        this.stringQuote = stringQuote;
    }

    public String getBracketBegin() {
        return this.bracketBegin;
    }

    public void setBracketBegin(String bracketBegin) {
        this.bracketBegin = bracketBegin;
    }

    public String getBracketEnd() {
        return this.bracketEnd;
    }

    public void setBracketEnd(String bracketEnd) {
        this.bracketEnd = bracketEnd;
    }

    public String getDefaultDateFormat() {
        return this.defaultDateFormat;
    }

    public void setDefaultDateFormat(String defaultDateFormat) {
        this.defaultDateFormat = defaultDateFormat;
    }

    public String getDefaultNumberFormat() {
        return this.defaultNumberFormat;
    }

    public void setDefaultNumberFormat(String defaultNumberFormat) {
        this.defaultNumberFormat = defaultNumberFormat;
    }

    public boolean isIgnoreRootBracket() {
        return this.ignoreRootBracket;
    }

    public void setIgnoreRootBracket(boolean ignoreRootBracket) {
        this.ignoreRootBracket = ignoreRootBracket;
    }

    public int getBracketDepth() {
        return this.compositeBracket.getBracketDepth();
    }

    public void setBracketDepth(int bracketDepth) {
        this.compositeBracket.setBracketDepth(bracketDepth);
    }

    class CompositeBracket {
        private int depth = 0;
        private int bracketDepth = 2;

        CompositeBracket() {
        }

        public void increment() {
            ++this.depth;
        }

        public void reset() {
            this.depth = 0;
        }

        public int getDepth() {
            return this.depth;
        }

        public boolean needBracket() {
            return this.depth >= this.getBracketDepth();
        }

        public int getBracketDepth() {
            return this.bracketDepth;
        }

        public void setBracketDepth(int bracketDepth) {
            this.bracketDepth = bracketDepth;
        }
    }
}

