/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.resource.impl;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.asyrinx.brownie.core.resource.MessageResource;
import org.asyrinx.brownie.core.resource.MessageResourceRuntimeException;

public class ResourceBundleMessageResource
implements MessageResource {
    protected final Locale locale;
    protected final String path;

    public ResourceBundleMessageResource(String path) {
        this(path, Locale.getDefault());
    }

    public ResourceBundleMessageResource(String path, Locale locale) {
        this.path = path;
        this.locale = locale;
    }

    public String getBase() {
        return this.path;
    }

    public String getMessage(String key) {
        ResourceBundle bundle = ResourceBundle.getBundle(this.path, this.locale);
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            throw new MessageResourceRuntimeException("Can't find resource key=" + key + " path=" + this.path, this.path, key, e);
        }
    }
}

