/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.hibernate.logger;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.Reference;
import net.sf.hibernate.Databinder;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.metadata.ClassMetadata;
import net.sf.hibernate.metadata.CollectionMetadata;
import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.core.log.DispatchLog;
import org.asyrinx.brownie.hibernate.logger.LogDatabinder;
import org.asyrinx.brownie.hibernate.logger.LogSession;
import org.asyrinx.brownie.hibernate.wrapper.SessionFactoryWrapper;

public class LogSessionFactory
extends SessionFactoryWrapper {
    private final CascadeNamedLog log;

    public LogSessionFactory() {
        this.log = new CascadeNamedLog(this.getClass());
    }

    public LogSessionFactory(SessionFactory source, CascadeNamedLog parentLog) {
        this.setSource(source);
        this.log = parentLog.subLog(source);
    }

    public String getDefaultLevel() {
        return this.log.getDefaultLevel();
    }

    public String getLoggerName() {
        return this.log.getLoggerName();
    }

    public void setDefaultLevel(String string) {
        this.log.setDefaultLevel(string);
    }

    public void setLoggerName(String string) {
        this.log.setLoggerName(string);
    }

    private DispatchLog getLog() {
        return this.log;
    }

    public void close() throws HibernateException {
        this.getLog().log("close()");
        super.close();
    }

    public void evict(Class persistentClass, Serializable id) throws HibernateException {
        this.getLog().log("evict(" + persistentClass.getName() + ", " + id + ")");
        super.evict(persistentClass, id);
    }

    public void evict(Class persistentClass) throws HibernateException {
        this.getLog().log("evict(" + persistentClass.getName() + ")");
        super.evict(persistentClass);
    }

    public void evictCollection(String roleName, Serializable id) throws HibernateException {
        this.getLog().log("evict(" + roleName + ", " + id + ")");
        super.evictCollection(roleName, id);
    }

    public void evictCollection(String roleName) throws HibernateException {
        this.getLog().log("evict(" + roleName + ")");
        super.evictCollection(roleName);
    }

    public void evictQueries() throws HibernateException {
        this.getLog().log("evictQueries()");
        super.evictQueries();
    }

    public void evictQueries(String cacheRegion) throws HibernateException {
        this.getLog().log("evictQueries(" + cacheRegion + ")");
        super.evictQueries(cacheRegion);
    }

    public Map getAllClassMetadata() throws HibernateException {
        return super.getAllClassMetadata();
    }

    public Map getAllCollectionMetadata() throws HibernateException {
        return super.getAllCollectionMetadata();
    }

    public ClassMetadata getClassMetadata(Class persistentClass) throws HibernateException {
        return super.getClassMetadata(persistentClass);
    }

    public CollectionMetadata getCollectionMetadata(String roleName) throws HibernateException {
        return super.getCollectionMetadata(roleName);
    }

    public Reference getReference() throws NamingException {
        return super.getReference();
    }

    public Databinder openDatabinder() throws HibernateException {
        Databinder result = super.openDatabinder();
        this.getLog().log("openDatabinder()");
        return new LogDatabinder(result, this.log.subLog(result));
    }

    public Session openSession() throws HibernateException {
        Session result = super.openSession();
        this.getLog().log("openSession()");
        return new LogSession(result, this.log.subLog(result));
    }

    public Session openSession(Connection connection, Interceptor interceptor) {
        Session result = super.openSession(connection, interceptor);
        this.getLog().log("openSession(" + connection + ", " + interceptor + ")");
        return new LogSession(result, this.log.subLog(result));
    }

    public Session openSession(Connection connection) {
        Session result = super.openSession(connection);
        this.getLog().log("openSession(" + connection + ")");
        return new LogSession(result, this.log.subLog(result));
    }

    public Session openSession(Interceptor interceptor) throws HibernateException {
        Session result = super.openSession(interceptor);
        this.getLog().log("openSession(" + interceptor + ")");
        return new LogSession(result, this.log.subLog(result));
    }
}

