/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.jdbc.logger;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.jdbc.wrapper.StatementWrapper;

public class LogStatement
extends StatementWrapper {
    protected final CascadeNamedLog log;
    protected final List batches = new ArrayList();

    public LogStatement(Statement wrapped, CascadeNamedLog parentLog) {
        super(wrapped);
        this.log = parentLog.subLog(this.wrapped);
    }

    protected void log(Object message) {
        this.log.log(message);
    }

    protected void log(Object message, Throwable t) {
        this.log.log(message, t);
    }

    protected void logBatch(int[] results) {
        StringBuffer result = new StringBuffer("batch executed:\n");
        Iterator iterator = this.batches.iterator();
        int idx = 0;
        while (iterator.hasNext()) {
            if (idx > results.length - 1) break;
            String sql = (String)iterator.next();
            result.append(idx).append(" [").append(results[idx]).append("]");
            result.append(sql).append("\n");
            ++idx;
        }
        this.log.log(result.toString());
    }

    protected void logBatch(Throwable t) {
        StringBuffer result = new StringBuffer("batch executed:\n");
        Iterator iterator = this.batches.iterator();
        int idx = 0;
        while (iterator.hasNext()) {
            String sql = (String)iterator.next();
            result.append(idx).append(" [?]");
            result.append(sql).append("\n");
            ++idx;
        }
        this.log.log((Object)result.toString(), t);
    }

    public void addBatch(String sql) throws SQLException {
        super.addBatch(sql);
        this.batches.add(sql);
    }

    public void clearBatch() throws SQLException {
        super.clearBatch();
        this.batches.clear();
    }

    public boolean execute(String sql) throws SQLException {
        try {
            boolean result = super.execute(sql);
            this.log(sql);
            return result;
        }
        catch (SQLException e) {
            this.log(sql, e);
            throw e;
        }
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            boolean result = super.execute(sql, autoGeneratedKeys);
            this.log(sql);
            return result;
        }
        catch (SQLException e) {
            this.log(sql, e);
            throw e;
        }
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            boolean result = super.execute(sql, columnIndexes);
            this.log(sql);
            return result;
        }
        catch (SQLException e) {
            this.log(sql, e);
            throw e;
        }
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            boolean result = super.execute(sql, columnNames);
            this.log(sql);
            return result;
        }
        catch (SQLException e) {
            this.log(sql, e);
            throw e;
        }
    }

    public int[] executeBatch() throws SQLException {
        try {
            int[] result = super.executeBatch();
            this.logBatch(result);
            return result;
        }
        catch (SQLException e) {
            this.logBatch(e);
            throw e;
        }
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            ResultSet result = super.executeQuery(sql);
            this.log(sql);
            return result;
        }
        catch (SQLException e) {
            this.log(sql, e);
            throw e;
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        try {
            int result = super.executeUpdate(sql);
            this.log(sql);
            return result;
        }
        catch (SQLException e) {
            this.log(sql, e);
            throw e;
        }
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            int result = super.executeUpdate(sql, autoGeneratedKeys);
            this.log(sql);
            return result;
        }
        catch (SQLException e) {
            this.log(sql, e);
            throw e;
        }
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            int result = super.executeUpdate(sql, columnIndexes);
            this.log(sql);
            return result;
        }
        catch (SQLException e) {
            this.log(sql, e);
            throw e;
        }
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            int result = super.executeUpdate(sql, columnNames);
            this.log(sql);
            return result;
        }
        catch (SQLException e) {
            this.log(sql, e);
            throw e;
        }
    }
}

