/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.seasar.dbcp.logger;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.jdbc.logger.LogConnection;
import org.asyrinx.brownie.jdbc.logger.LogXAConnection;
import org.asyrinx.brownie.jdbc.logger.LogXAResource;
import org.seasar.extension.dbcp.ConnectionWrapper;

public class LogConnectionWrapper
extends LogConnection
implements ConnectionWrapper {
    protected final CascadeNamedLog log;
    protected final ConnectionWrapper wrapped;

    public LogConnectionWrapper(ConnectionWrapper wrapped) {
        this(wrapped, new CascadeNamedLog(wrapped.getClass(), "debug"));
    }

    public LogConnectionWrapper(ConnectionWrapper wrapped, CascadeNamedLog log) {
        super((Connection)wrapped);
        this.wrapped = wrapped;
        this.log = log;
    }

    public void closeReally() {
        try {
            this.wrapped.closeReally();
            this.log.log("closeReally()");
        }
        catch (RuntimeException e) {
            this.log.error("failed closeReally()", e);
            throw e;
        }
    }

    public Connection getPhysicalConnection() {
        try {
            Connection result = this.wrapped.getPhysicalConnection();
            this.log.log("getPhysicalConnection(): " + result);
            return new LogConnection(result, this.log.subLog(result));
        }
        catch (RuntimeException e) {
            this.log.error("failed getPhysicalConnection()", e);
            throw e;
        }
    }

    public XAConnection getXAConnection() {
        try {
            XAConnection result = this.wrapped.getXAConnection();
            this.log.log("getXAConnection(): " + result);
            return new LogXAConnection(result, this.log.subLog(result));
        }
        catch (RuntimeException e) {
            this.log.error("failed getXAConnection()", e);
            throw e;
        }
    }

    public XAResource getXAResource() {
        try {
            XAResource result = this.wrapped.getXAResource();
            this.log.log("getXAResource(): " + result);
            return new LogXAResource(result, this.log.subLog(result));
        }
        catch (RuntimeException e) {
            this.log.error("failed getXAResource()", e);
            throw e;
        }
    }

    public void init() {
        this.wrapped.init();
        this.log.log("init()");
    }

    public void release() throws SQLException {
        try {
            this.wrapped.release();
            this.log.log("release()");
        }
        catch (SQLException e) {
            this.log.error("failed release()", e);
            throw e;
        }
    }
}

