/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;
import org.asyrinx.brownie.core.util.jp.JpDateFormat;
import org.asyrinx.brownie.swing.DatePicker;

public final class DateField
extends JPanel {
    protected final JTextField dateText = new JTextField();
    private final JButton dropdownButton = new JButton();
    private DateFormat dateFormat = new JpDateFormat("yyyy/MM/dd HH:mm:ss");

    public DateField() {
        this.initialize();
    }

    public DateField(Date initialDate) {
        this.initialize();
        this.dateText.setText(this.dateToString(initialDate));
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 0));
        this.add((Component)this.dateText, null);
        this.add((Component)this.dropdownButton, null);
        this.dateText.setText("");
        this.dateText.setEditable(true);
        this.dateText.setBackground(new Color(255, 255, 255));
        this.dropdownButton.setText("...");
        this.dropdownButton.setMargin(new Insets(2, 2, 2, 2));
        this.dropdownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DateField.this.onButtonClick(evt);
            }
        });
        this.setSize(201, 37);
        this.setPreferredSize(new Dimension(25, 21));
        this.dateText.setPreferredSize(new Dimension(6, 18));
    }

    public Date getDate() {
        return this.stringToDate(this.dateText.getText());
    }

    public void setDate(Date date) {
        this.dateText.setText(this.dateToString(date));
    }

    protected void onButtonClick(ActionEvent e) {
        final JDialog dlg = new JDialog((Frame)new JFrame(), true);
        DatePicker dp = StringUtils.isEmpty((String)this.dateText.getText()) ? new DatePicker() : new DatePicker(this.stringToDate(this.dateText.getText()));
        dp.setHideOnSelect(true);
        dp.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent evt) {
                Date dt = ((DatePicker)evt.getSource()).getDate();
                if (dt != null) {
                    DateField.this.dateText.setText(DateField.this.dateToString(dt));
                }
                dlg.dispose();
            }
        });
        Point p = this.dateText.getLocationOnScreen();
        p.setLocation(p.getX(), p.getY() - 1.0 + this.dateText.getSize().getHeight());
        dlg.setLocation(p);
        dlg.setResizable(false);
        dlg.setUndecorated(true);
        dlg.getContentPane().add(dp);
        dlg.pack();
        dlg.show();
    }

    protected String dateToString(Date dt) {
        return dt == null ? null : this.dateFormat.format(dt);
    }

    private Date stringToDate(String s) {
        if (StringUtils.isEmpty((String)s)) {
            return null;
        }
        try {
            return this.dateFormat.parse(s);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getPattern() {
        if (this.dateFormat instanceof JpDateFormat) {
            return ((JpDateFormat)this.dateFormat).toPattern();
        }
        if (this.dateFormat instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)this.dateFormat).toPattern();
        }
        return null;
    }

    public void setPattern(String pattern) {
        this.dateFormat = this.dateFormat instanceof SimpleDateFormat ? new SimpleDateFormat(pattern) : new JpDateFormat(pattern);
    }

    public String getText() {
        return this.dateText.getText();
    }

    public boolean isEditable() {
        return this.dateText.isEditable();
    }

    public void setEditable(boolean b) {
        this.dateText.setEditable(b);
        this.dropdownButton.setEnabled(b);
    }

    public void setText(String t) {
        this.dateText.setText(t);
    }
}

