/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.tapestry.components.form;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.form.AbstractTextField;

public abstract class TimeField
extends AbstractTextField {
    final DateFormat[] defaultFormats = new DateFormat[]{new SimpleDateFormat("HH:mm:ss.SSS"), new SimpleDateFormat("HH:mm:ss"), new SimpleDateFormat("HH:mm"), new SimpleDateFormat("HH")};
    private final DateFormat defaultFormat = this.defaultFormats[1];
    final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    static /* synthetic */ Class class$0;

    public abstract IBinding getValueBinding();

    public abstract DateFormat getFormat();

    public String readValue() {
        Date date;
        IBinding iBinding = this.getValueBinding();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((date = (Date)iBinding.getObject("value", (Class)clazz)) == null) {
            return "";
        }
        this.debug(date, "readValue");
        DateFormat format = this.getFormat();
        if (format != null) {
            return format.format(date);
        }
        return this.defaultFormat.format(date);
    }

    private void debug(Date date, String methodName) {
        GregorianCalendar dateCalendar = new GregorianCalendar();
        dateCalendar.setTime(date);
        int h = dateCalendar.get(11);
        int m = dateCalendar.get(12);
        int s = dateCalendar.get(13);
        int ms = dateCalendar.get(14);
        this.log.debug((Object)(String.valueOf(methodName) + " h:m:s:ms=" + h + ":" + m + ":" + s + ":" + ms));
    }

    public void updateValue(String value) {
        Date originalValue;
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        IBinding iBinding = this.getValueBinding();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((originalValue = (Date)iBinding.getObject("value", (Class)clazz)) == null) {
            originalValue = new Date();
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(originalValue);
        Date date = this.toDate(value);
        GregorianCalendar dateCalendar = new GregorianCalendar();
        dateCalendar.setTime(date);
        calendar.set(11, dateCalendar.get(11));
        calendar.set(12, dateCalendar.get(12));
        calendar.set(13, dateCalendar.get(13));
        calendar.set(14, dateCalendar.get(14));
        this.debug(calendar.getTime(), "readValue calendar.getTime()");
        Date result = new Date(calendar.getTime().getTime());
        this.debug(result, "readValue result");
        this.getValueBinding().setObject((Object)result);
    }

    private Date toDate(String value) {
        try {
            DateFormat dateFormat = this.getFormat();
            if (dateFormat != null) {
                return dateFormat.parse(value);
            }
            return this.parseByDefaultFormats(value);
        }
        catch (ParseException e) {
            return this.parseByDefaultFormats(value);
        }
    }

    private Date parseByDefaultFormats(String value) {
        int i = 0;
        while (i < this.defaultFormats.length) {
            try {
                return this.defaultFormats[i].parse(value);
            }
            catch (ParseException parseException) {
                ++i;
            }
        }
        return null;
    }
}

