/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.tapestry.components.layer;

import java.util.Map;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.brownie.core.lang.NumberUtils;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.tapestry.script.IScriptUser;
import org.asyrinx.brownie.tapestry.script.ScriptWriter;

public abstract class AbstractLayerComponent
extends AbstractComponent
implements IScriptUser {
    protected final ScriptWriter scriptWriter;
    private String left = null;
    private String top = null;
    private String width = null;
    private String height = null;
    private String backGroundColor = null;

    protected AbstractLayerComponent(String scriptName) {
        this.scriptWriter = new ScriptWriter(this, scriptName);
    }

    public void prepareScriptSymbols(Map symbols, IRequestCycle cycle) {
        symbols.put("id", this.getStyleId());
        symbols.put("left", new Integer(NumberUtils.toInt(this.getLeft(), 0)));
        symbols.put("top", new Integer(NumberUtils.toInt(this.getTop(), 0)));
        symbols.put("width", new Integer(NumberUtils.toInt(this.getWidth(), 0)));
        symbols.put("height", new Integer(NumberUtils.toInt(this.getHeight(), 0)));
    }

    public String toStyleValue() {
        StringBuffer result = new StringBuffer();
        this.addParam(result, "LEFT", this.left, "px");
        this.addParam(result, "TOP", this.top, "px");
        this.addParam(result, "WIDTH", this.width, "px");
        this.addParam(result, "HEIGHT", this.height, "px");
        if (!StringUtils.isEmpty((String)this.getWidth()) && !StringUtils.isEmpty((String)this.getHeight())) {
            result.append("CLIP:rect(");
            result.append("0px ");
            result.append(String.valueOf(this.width) + "px ");
            result.append(String.valueOf(this.height) + "px ");
            result.append("0px); ");
        }
        result.append("POSITION:absolute; ");
        this.addParam(result, "BACKGROUND-COLOR", this.backGroundColor, "");
        this.addParam(result, "layer-background-color", this.backGroundColor, "");
        return result.toString();
    }

    private void addParam(StringBuffer buffer, String name, String value, String suffix) {
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        buffer.append(String.valueOf(name) + ":" + value + suffix + "; ");
    }

    public abstract String getStyleId();

    public abstract void setStyleId(String var1);

    public String getHeight() {
        return this.height;
    }

    public String getLeft() {
        return this.left;
    }

    public String getTop() {
        return this.top;
    }

    public String getWidth() {
        return this.width;
    }

    public void setHeight(String string) {
        this.height = string;
    }

    public void setLeft(String string) {
        this.left = string;
    }

    public void setTop(String string) {
        this.top = string;
    }

    public void setWidth(String string) {
        this.width = string;
    }

    public String getBackGroundColor() {
        return this.backGroundColor;
    }

    public void setBackGroundColor(String string) {
        this.backGroundColor = string;
    }
}

