/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.tapestry.components.util;

import java.text.Format;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.asyrinx.brownie.core.lang.StringUtils;

public abstract class Insert
extends AbstractComponent {
    public abstract IBinding getFormatBinding();

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        if (cycle.isRewinding()) {
            return;
        }
        Object value = this.getValue();
        if (value == null) {
            return;
        }
        String insert = this.buildInsertValue(value);
        String styleClass = this.getStyleClass();
        if (styleClass != null) {
            writer.begin("span");
            writer.attribute("class", styleClass);
            this.renderInformalParameters(writer, cycle);
        }
        if (this.getRaw()) {
            writer.printRaw(insert);
        } else {
            writer.print(insert);
        }
        if (styleClass != null) {
            writer.end();
        }
    }

    private String buildInsertValue(Object value) {
        String result;
        Format format = this.getFormat();
        if (format == null) {
            result = value.toString();
        } else {
            try {
                result = format.format(value);
            }
            catch (Exception ex) {
                throw new ApplicationRuntimeException(Tapestry.format((String)"Insert.unable-to-format", (Object)value), (Object)this, this.getFormatBinding().getLocation(), (Throwable)ex);
            }
        }
        return this.abbreviate(result);
    }

    private String abbreviate(String value) {
        if (value == null) {
            return null;
        }
        if (this.getMaxlength() < 1) {
            return value;
        }
        if (this.getMaxlength() > 3) {
            return StringUtils.abbreviate((String)value, (int)this.getMaxlength());
        }
        if (value.length() > this.getMaxlength()) {
            return value.substring(0, this.getMaxlength());
        }
        return value;
    }

    public abstract Object getValue();

    public abstract Format getFormat();

    public abstract String getStyleClass();

    public abstract boolean getRaw();

    public abstract int getMaxlength();
}

