/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.validator.impl;

import java.util.Iterator;
import org.apache.commons.lang.enum.Enum;
import org.asyrinx.brownie.validator.ValidationContext;
import org.asyrinx.brownie.validator.Validator;
import org.asyrinx.brownie.validator.impl.CompositeValidator;

public abstract class CompositeType
extends Enum {
    public static final CompositeType AND = new CompositeType("and"){

        public void evaluate(CompositeValidator composite, ValidationContext context, Object obj) {
            ValidationContext subContext = context.createSubContext();
            Iterator i = composite.iterator();
            while (i.hasNext()) {
                Validator v = (Validator)i.next();
                v.evaluate(subContext, obj);
            }
            if (!subContext.getMatters().isEmpty()) {
                context.addMessages(subContext);
            }
        }
    };
    public static final CompositeType OR = new CompositeType("or"){

        public void evaluate(CompositeValidator composite, ValidationContext context, Object obj) {
            ValidationContext subContext = context.createSubContext();
            Iterator i = composite.iterator();
            while (i.hasNext()) {
                Validator v = (Validator)i.next();
                int lastMessageSize = subContext.getMessages().size();
                v.evaluate(subContext, obj);
                if (lastMessageSize != subContext.getMessages().size()) continue;
                return;
            }
            context.addMessages(subContext);
        }
    };

    public CompositeType(String name) {
        super(name);
    }

    public static CompositeType get(String name) {
        if ("and".equalsIgnoreCase(name)) {
            return AND;
        }
        if ("or".equalsIgnoreCase(name)) {
            return OR;
        }
        throw new UnsupportedOperationException("unknown CompositeType name:" + name);
    }

    public abstract void evaluate(CompositeValidator var1, ValidationContext var2, Object var3);
}

