/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.validator.prop;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.asyrinx.brownie.validator.Message;
import org.asyrinx.brownie.validator.ValidationContext;
import org.asyrinx.brownie.validator.ValidatorRuntimeException;
import org.asyrinx.brownie.validator.prop.PropertyValidator;

public abstract class AbstractPropertyValidator
implements PropertyValidator {
    protected final String propertyName;
    protected final String displayName;
    static /* synthetic */ Class class$0;

    public AbstractPropertyValidator(String propertyName, String displayName) {
        this.propertyName = propertyName;
        this.displayName = displayName;
    }

    public Class getPropertyClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public abstract void evaluate(ValidationContext var1, Object var2, Object var3);

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    protected String getMessageKey() {
        return this.getClass().getName();
    }

    public void evaluate(ValidationContext context, Object obj) {
        Object propertyValue;
        try {
            propertyValue = PropertyUtils.getProperty((Object)obj, (String)this.propertyName);
        }
        catch (Exception e) {
            throw new ValidatorRuntimeException(e);
        }
        if (propertyValue != null && !this.getPropertyClass().isInstance(propertyValue)) {
            throw new ValidatorRuntimeException("propertyValue isn't a intance of " + this.getPropertyClass().getName());
        }
        this.evaluate(context, obj, propertyValue);
    }

    protected String getPropertyAsString(Object obj) {
        try {
            return BeanUtils.getProperty((Object)obj, (String)this.propertyName);
        }
        catch (Exception e) {
            throw new ValidatorRuntimeException(e);
        }
    }

    protected Object getPropertyAsObject(Object obj) {
        try {
            return PropertyUtils.getProperty((Object)obj, (String)this.propertyName);
        }
        catch (Exception e) {
            throw new ValidatorRuntimeException(e);
        }
    }

    protected void addError(ValidationContext context) {
        HashMap parameters = new HashMap(3);
        this.prepareParameters(parameters);
        Message message = context.addError(this.getMessageKey(), parameters);
        message.addProperty(this.getPropertyName());
    }

    protected void prepareParameters(Map parameters) {
        parameters.put("displayName", this.getDisplayName());
    }
}

