/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.validator.prop;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.validator.ValidationContext;
import org.asyrinx.brownie.validator.prop.AbstractPropertyValidator;
import org.asyrinx.brownie.validator.prop.MaxByteLength;
import org.asyrinx.brownie.validator.prop.PropertyValidator;
import org.asyrinx.brownie.validator.prop.RegExp;
import org.asyrinx.brownie.validator.prop.Required;

public abstract class AbstractStringField
extends AbstractPropertyValidator {
    private final List validators = new ArrayList(5);
    private boolean prepared = false;
    private String regExp;
    private final boolean required;
    private int maxLength = 0;

    public AbstractStringField(String propertyName, String displayName, boolean required, int maxLength) {
        super(propertyName, displayName);
        this.required = required;
        this.maxLength = maxLength;
        if (required) {
            this.addValidator(new Required(propertyName, displayName));
        }
        if (maxLength > 0) {
            this.addValidator(new MaxByteLength(propertyName, displayName, maxLength));
        }
    }

    public List getValidators() {
        return Collections.unmodifiableList(this.validators);
    }

    public final void addValidator(PropertyValidator validator) {
        if (validator == null) {
            return;
        }
        this.validators.add(validator);
    }

    public void evaluate(ValidationContext context, Object obj, Object propertyValue) {
        if (!this.prepared) {
            this.prepareValidators();
            this.prepared = true;
        }
        Iterator i = this.validators.iterator();
        while (i.hasNext()) {
            PropertyValidator validator = (PropertyValidator)i.next();
            validator.evaluate(context, obj, propertyValue);
        }
    }

    protected void prepareValidators() {
        if (!StringUtils.isEmpty((String)this.getRegExp())) {
            this.addValidator(new RegExp(this.propertyName, this.displayName, this.getRegExp()));
        }
    }

    public String getRegExp() {
        return this.regExp;
    }

    public void setRegExp(String regExp) {
        this.regExp = regExp;
    }

    public boolean isRequired() {
        return this.required;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }
}

