/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.validator.prop;

import java.util.Map;
import org.asyrinx.brownie.validator.ValidationContext;
import org.asyrinx.brownie.validator.prop.AbstractPropertyValidator;

public class AcceptableCharacter
extends AbstractPropertyValidator {
    private final String chars;
    private final boolean refuse;

    public AcceptableCharacter(String propertyName, String displayName, String chars) {
        this(propertyName, displayName, chars, false);
    }

    public AcceptableCharacter(String propertyName, String displayName, String chars, boolean refuse) {
        super(propertyName, displayName);
        this.chars = chars;
        this.refuse = refuse;
    }

    public void evaluate(ValidationContext context, Object obj, Object propertyValue) {
        if (!this.checkAcceptable((String)propertyValue)) {
            this.addError(context);
        }
    }

    protected String getMessageKey() {
        return String.valueOf(super.getMessageKey()) + (this.refuse ? ".refuse" : ".accept");
    }

    protected void prepareParameters(Map parameters) {
        super.prepareParameters(parameters);
        parameters.put("acceptable", this.getChars());
    }

    private boolean checkAcceptable(String propValue) {
        if (propValue == null) {
            return true;
        }
        int i = 0;
        while (i < propValue.length()) {
            char c = propValue.charAt(i);
            if (this.chars.indexOf(c) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getChars() {
        return this.chars;
    }

    public boolean isRefuse() {
        return this.refuse;
    }
}

