/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.validator.prop;

import java.util.Map;
import java.util.regex.Pattern;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.validator.ValidationContext;
import org.asyrinx.brownie.validator.prop.AbstractPropertyValidator;

public class RegExp
extends AbstractPropertyValidator {
    private final String expression;
    private final Pattern pattern;

    public RegExp(String propertyName, String displayName, String expression) {
        super(propertyName, displayName);
        this.expression = expression;
        this.pattern = Pattern.compile(expression);
    }

    public void evaluate(ValidationContext context, Object obj, Object propertyValue) {
        if (StringUtils.isEmpty((String)((String)propertyValue))) {
            return;
        }
        if (!this.pattern.matcher((String)propertyValue).matches()) {
            this.addError(context);
        }
    }

    protected void prepareParameters(Map parameters) {
        super.prepareParameters(parameters);
        parameters.put("expression", this.expression);
    }
}

